% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{d3_force_layout}
\alias{d3_force_layout}
\title{Generate G6 D3 Force layout configuration}
\usage{
d3_force_layout(
  link = list(distance = 100, strength = 2),
  collide = list(radius = 40),
  ...
)
}
\arguments{
\item{link}{A list specifying force parameters for links (edges), with components:
\describe{
\item{id}{Edge id generation function, format: \code{function(edge, index, edges) { return string }}. Default is \code{function(e) e.id}}
\item{distance}{Ideal edge length that edges will tend toward. Can be a number or a function
\code{function(edge, index, edges) { return number }}. Default is 30}
\item{strength}{The strength of the force. Higher values make edge lengths closer to the ideal length.
Can be a number or a function \code{function(edge, index, edges) { return number }}. Default is 1}
\item{iterations}{Number of iterations of link force. Default is 1}
}}

\item{collide}{A list specifying collision force parameters for nodes, with components:
\describe{
\item{radius}{Collision radius. Nodes closer than this distance will experience a repulsive force.
Can be a number or a function \code{function(node, index, nodes) { return number }}. Default is 10}
\item{strength}{The strength of the repulsive force. Higher values produce more obvious repulsion. Default is 1}
\item{iterations}{The number of iterations for collision detection. Default is 1}
}}

\item{...}{Additional parameters to pass to the layout.
See \url{https://g6.antv.antgroup.com/en/manual/layout/d3-force}.}
}
\value{
A list containing the configuration for G6 AntV D3 Force layout.
}
\description{
This function creates a configuration list for G6 D3 Force layout
with all available options as parameters.
}
\examples{
# Basic D3 force layout
d3_force_config <- d3_force_layout()

# Custom link distance and collision radius
d3_force_config <- d3_force_layout(
  link = list(
    distance = 150,
    strength = 0.5,
    iterations = 3
  ),
  collide = list(
    radius = 30,
    strength = 0.8
  )
)
}
