% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{edge_bundling}
\alias{edge_bundling}
\title{Configure Edge Bundling Plugin}
\usage{
edge_bundling(
  key = "edge-bundling",
  bundleThreshold = 0.6,
  cycles = 6,
  divisions = 1,
  divRate = 2,
  iterations = 90,
  iterRate = 2/3,
  K = 0.1,
  lambda = 0.1,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the plugin (string, default: NULL).}

\item{bundleThreshold}{Edge compatibility threshold, determines which edges
should be bundled together (number, default: 0.6).}

\item{cycles}{Number of simulation cycles (number, default: 6).}

\item{divisions}{Initial number of cut points (number, default: 1).}

\item{divRate}{Growth rate of cut points (number, default: 2).}

\item{iterations}{Number of iterations executed in the first cycle (number, default: 90).}

\item{iterRate}{Iteration decrement rate (number, default: 2/3).}

\item{K}{Edge strength, affects attraction and repulsion between edges (number, default: 0.1).}

\item{lambda}{Initial step size (number, default: 0.1).}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/edge-bundling}.}
}
\value{
A list with the configuration settings for the edge-bundling plugin.
}
\description{
Creates a configuration object for the edge-bundling plugin in G6.
This plugin automatically bundles similar edges together to reduce visual clutter.
}
\examples{
# Basic configuration
config <- edge_bundling()

# Custom configuration
config <- edge_bundling(
  key = "my-edge-bundling",
  bundleThreshold = 0.8,
  cycles = 8,
  K = 0.2
)
}
