/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.DesktopPaneBG;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.CreateGraphGUI;
import org.mutoss.gui.RControl;
import org.mutoss.gui.datatable.DataTable;
import org.mutoss.gui.dialogs.AdjustedPValueDialog;
import org.mutoss.gui.dialogs.CorrelatedTest;
import org.mutoss.gui.dialogs.DialogConfIntEstVar;
import org.mutoss.gui.graph.Edge;
import org.mutoss.gui.graph.EdgeWeight;
import org.mutoss.gui.graph.NetList;
import org.mutoss.gui.graph.PView;
import org.mutoss.gui.graph.VS;

public class GraphView
extends JPanel
implements ActionListener {
    String name;
    CreateGraphGUI parent;
    public static final String STATUSBAR_DEFAULT = "Place new nodes and edges or start the test procedure";
    JLabel statusBar;
    public NetList nl;
    VS vs = new VS();
    JButton buttonNewVertex;
    JButton buttonNewEdge;
    JButton buttonZoomOut;
    JButton buttonZoomIn;
    JButton buttonadjPval;
    JButton buttonConfInt;
    JButton buttonStart;
    JButton buttonBack;
    private static final Log logger = LogFactory.getLog(GraphView.class);

    public String getGraphName() {
        return this.name;
    }

    public JFrame getMainFrame() {
        return this.parent;
    }

    public PView getPView() {
        return this.parent.getPView();
    }

    public void updateEdge(int from, int to, Double w) {
        this.updateEdge(from, to, new EdgeWeight(w));
    }

    public DataTable getDataTable() {
        return this.parent.getDataTable();
    }

    public CreateGraphGUI getGraphGUI() {
        return this.parent;
    }

    public GraphView(String graph, CreateGraphGUI createGraphGUI) {
        this.name = graph;
        this.parent = createGraphGUI;
        this.statusBar = new JLabel(STATUSBAR_DEFAULT);
        this.nl = new NetList(this.statusBar, this.vs, this);
        this.setLayout(new BorderLayout());
        this.add("North", this.getNorthPanel());
        JScrollPane sPane = new JScrollPane(this.nl);
        this.add("Center", sPane);
    }

    public JPanel getNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.getToolBar());
        panel.add("South", this.statusBar);
        return panel;
    }

    public JPanel getToolBar() {
        JPanel toolPanel = new JPanel();
        try {
            toolPanel.setLayout(new FlowLayout());
            ((FlowLayout)toolPanel.getLayout()).setAlignment(0);
            this.buttonNewVertex = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/vertex.png"))));
            toolPanel.add(this.buttonNewVertex);
            this.buttonNewVertex.addActionListener(this);
            this.buttonNewVertex.setToolTipText("new vertex");
            this.buttonNewEdge = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/edge.png"))));
            toolPanel.add(this.buttonNewEdge);
            this.buttonNewEdge.addActionListener(this);
            this.buttonNewEdge.setToolTipText("new edge");
            this.buttonZoomOut = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/zoom_out.png"))));
            toolPanel.add(this.buttonZoomOut);
            this.buttonZoomOut.addActionListener(this);
            this.buttonZoomOut.setToolTipText("zoom out");
            this.buttonZoomIn = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/zoom_in.png"))));
            toolPanel.add(this.buttonZoomIn);
            this.buttonZoomIn.addActionListener(this);
            this.buttonZoomIn.setToolTipText("zoom in");
            this.buttonadjPval = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/adjPval.png"))));
            toolPanel.add(this.buttonadjPval);
            this.buttonadjPval.addActionListener(this);
            this.buttonadjPval.setToolTipText("calculate adjusted p-values");
            this.buttonConfInt = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/confint2.png"))));
            toolPanel.add(this.buttonConfInt);
            this.buttonConfInt.addActionListener(this);
            this.buttonConfInt.setToolTipText("calculate confidence intervals");
            this.buttonStart = new JButton(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/StartTesting.png"))));
            toolPanel.add(this.buttonStart);
            this.buttonStart.addActionListener(this);
            this.buttonStart.setEnabled(false);
            this.buttonStart.setToolTipText("start testing");
        }
        catch (IOException e) {
            ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e);
        }
        return toolPanel;
    }

    public NetList getNL() {
        return this.nl;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonZoomIn)) {
            this.vs.setZoom(this.vs.getZoom() * 1.25);
            this.getNL().refresh();
        } else if (e.getSource().equals(this.buttonZoomOut)) {
            this.vs.setZoom(this.vs.getZoom() / 1.25);
            this.getNL().refresh();
        } else if (e.getSource().equals(this.buttonNewEdge)) {
            this.vs.newVertex = false;
            this.vs.newEdge = true;
            this.getNL().statusBar.setText("Select a node from which this edge should start.");
        } else if (e.getSource().equals(this.buttonNewVertex)) {
            this.vs.newVertex = true;
            this.vs.newEdge = false;
            this.getNL().statusBar.setText("Click on the graph panel to place the node.");
        } else if (e.getSource().equals(this.buttonConfInt)) {
            if (!this.getNL().isTesting()) {
                this.getNL().saveGraph();
                this.getPView().savePValues();
            }
            if (this.getNL().getKnoten().size() == 0) {
                JOptionPane.showMessageDialog(this.parent, "Please create first a graph.", "Please create first a graph.", 0);
            } else {
                new DialogConfIntEstVar(this.parent, this, this.nl);
            }
        } else if (e.getSource().equals(this.buttonStart)) {
            if (!this.getNL().isTesting()) {
                this.startTesting();
                new CorrelatedTest(this.getGraphGUI());
            } else {
                this.stopTesting();
            }
        } else if (e.getSource().equals(this.buttonadjPval)) {
            if (this.getNL().getKnoten().size() == 0) {
                JOptionPane.showMessageDialog(this.parent, "Please create first a graph.", "Please create first a graph.", 0);
            } else {
                if (!this.getNL().isTesting()) {
                    this.getNL().saveGraph();
                    this.getPView().savePValues();
                }
                String pValues = this.getPView().getPValuesString();
                double[] adjPValues = RControl.getR().eval("gMCP:::adjPValues(" + this.getNL().initialGraph + "," + pValues + ")@adjPValues").asRNumeric().getData();
                new AdjustedPValueDialog(this.parent, this.getPView().pValues, adjPValues, this.getNL().getKnoten());
            }
        }
    }

    public VS getVS() {
        return this.vs;
    }

    public void stopTesting() {
        if (!this.getNL().testingStarted) {
            return;
        }
        this.getNL().stopTesting();
        this.getNL().reset();
        this.getNL().loadGraph();
        this.getPView().restorePValues();
        this.getPView().setTesting(false);
        this.getPView().revalidate();
        this.getPView().repaint();
        this.buttonNewVertex.setEnabled(true);
        this.buttonNewEdge.setEnabled(true);
        try {
            this.buttonStart.setIcon(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/StartTesting.png"))));
        }
        catch (IOException ex) {
            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
        }
    }

    public void startTesting() {
        if (this.getNL().testingStarted) {
            return;
        }
        this.getPView().savePValues();
        try {
            this.getNL().startTesting();
            this.getNL().saveGraph();
            this.getPView().setTesting(true);
            this.buttonNewVertex.setEnabled(false);
            this.buttonNewEdge.setEnabled(false);
            this.buttonStart.setIcon(new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/mutoss/gui/graph/images/Reset.png"))));
        }
        catch (Exception ex) {
            ErrorHandler.getInstance().makeErrDialog(ex.getMessage(), (Object)ex);
        }
    }

    public void WriteLaTeXwithR() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this.getMainFrame());
        if (returnVal != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        String filename = file.getAbsolutePath();
        this.nl.saveGraph(".exportGraphToLaTeX", false);
        RControl.getR().eval("gMCPReport(.exportGraphToLaTeX, file=\"" + filename + "\")");
    }

    public void updateEdge(int from, int to, EdgeWeight weight) {
        logger.info((Object)("Adding Edge from " + from + " to " + to + " with weight " + weight.toString() + "."));
        Edge e = this.getNL().findEdge(this.getNL().getKnoten().get(from), this.getNL().getKnoten().get(to));
        if (e != null) {
            int x = e.getK1();
            int y = e.getK2();
            if (!weight.toString().equals("0")) {
                this.getNL().addEdge(new Edge(this.getNL().getKnoten().get(from), this.getNL().getKnoten().get(to), weight, this.getNL().vs, x, y));
            } else {
                this.getNL().removeEdge(e);
            }
        } else {
            this.getNL().addEdge(this.getNL().getKnoten().get(from), this.getNL().getKnoten().get(to), weight);
        }
        this.getNL().repaint();
    }
}

