/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JPanel;
import org.af.commons.images.GraphDrawHelper;
import org.af.commons.images.GraphException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.graph.EdgeWeight;
import org.mutoss.gui.graph.NetList;
import org.mutoss.gui.graph.Node;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge {
    private static final Log logger = LogFactory.getLog(Edge.class);
    public static Component panel = new JPanel();
    public boolean curve = false;
    FontRenderContext frc = null;
    Graphics2D g2d;
    int k1;
    int k2;
    public Node to;
    public Node from;
    NetList nl;
    private EdgeWeight ew;
    int lastFontSize = 16;
    TeXIcon icon = null;

    public Edge(Node von, Node nach, Double w, NetList nl) {
        int x1 = von.getX() + Node.getRadius();
        int x2 = nach.getX() + Node.getRadius();
        int y1 = von.getY() + Node.getRadius();
        int y2 = nach.getY() + Node.getRadius();
        this.k1 = x1 + (x2 - x1) / 4;
        this.k2 = y1 + (y2 - y1) / 4;
        this.from = von;
        this.to = nach;
        this.ew = new EdgeWeight(w);
        this.nl = nl;
    }

    public Edge(Node von, Node nach, Double w, NetList nl, boolean curve) {
        this(von, nach, w, nl);
        int x1 = von.getX() + Node.getRadius();
        int x2 = nach.getX() + Node.getRadius();
        int y1 = von.getY() + Node.getRadius();
        int y2 = nach.getY() + Node.getRadius();
        if (curve) {
            double d = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            double y = y2 - y1;
            double x = x2 - x1;
            double alpha = x == 0.0 && y < 0.0 ? 90.0 : (x == 0.0 && y > 0.0 ? -90.0 : Math.atan(-y / x) / (Math.PI * 2) * 360.0 + (double)(x < 0.0 ? 180 : 0));
            this.k1 = x1 + (int)(Math.cos((alpha += 10.0) * (Math.PI * 2) / 360.0) * d / 2.0);
            this.k2 = y1 - (int)(Math.sin(alpha * (Math.PI * 2) / 360.0) * d / 2.0);
        } else if (Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) > 200.0) {
            this.k1 = x1 + (x2 - x1) / 4;
            this.k2 = y1 + (y2 - y1) / 4;
        } else {
            this.k1 = x1 + (x2 - x1) / 2;
            this.k2 = y1 + (y2 - y1) / 2;
        }
    }

    public Edge(Node von, Node nach, Double w, NetList nl, int k1, int k2) {
        this.from = von;
        this.to = nach;
        this.ew = new EdgeWeight(w);
        this.nl = nl;
        this.k1 = k1;
        this.k2 = k2;
    }

    public Edge(Node from, Node to, String wStr, NetList nl, boolean curve) {
        this(from, to, new EdgeWeight(wStr), nl, curve);
    }

    public Edge(Node from, Node to, String wStr, NetList nl, int i, int j) {
        this(from, to, new EdgeWeight(wStr), nl, i, j);
    }

    public Edge(Node from, Node to, EdgeWeight ew, NetList nl, int k1, int k2) {
        this(from, to, 0.0, nl, k1, k2);
        this.ew = ew;
    }

    public Edge(Node from, Node to, EdgeWeight ew, NetList nl, boolean curve) {
        this(from, to, 0.0, nl, curve);
        this.ew = ew;
    }

    public int getBendLeft() {
        double[] m;
        int x1 = this.from.getX() + Node.getRadius();
        int x2 = this.to.getX() + Node.getRadius();
        int y1 = this.from.getY() + Node.getRadius();
        int y2 = this.to.getY() + Node.getRadius();
        try {
            m = GraphDrawHelper.getCenter((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2);
        }
        catch (GraphException e) {
            return 0;
        }
        double[] phi = GraphDrawHelper.getAngle((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2, (double)m[0], (double)m[1]);
        double gamma = x1 - x2 == 0 ? (double)(90 + (y2 - y1 > 0 ? 0 : 180)) : Math.atan((-y1 + y2) / (x1 - x2)) * 360.0 / (Math.PI * 2) + (double)(x1 - x2 < 0 ? 180 : 0);
        return ((int)(phi[2] + (double)(phi[1] > 0.0 ? 180 : 0) + 90.0 - gamma) + 360) % 360;
    }

    public int getK1() {
        return this.k1;
    }

    public int getK2() {
        return this.k2;
    }

    public double getPos() {
        double[] m;
        int x1 = this.from.getX() + Node.getRadius();
        int x2 = this.to.getX() + Node.getRadius();
        int y1 = this.from.getY() + Node.getRadius();
        int y2 = this.to.getY() + Node.getRadius();
        try {
            m = GraphDrawHelper.getCenter((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2);
            double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double r = Math.sqrt((m[0] - (double)x1) * (m[0] - (double)x1) + (m[1] - (double)y1) * (m[1] - (double)y1));
            if (Math.PI * 2 * r / 360.0 > 6.0 * d / 200.0) {
                throw new GraphException("Edge is too linear.");
            }
        }
        catch (GraphException e) {
            double n2 = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double k = Math.sqrt((this.k1 - x1) * (this.k1 - x1) + (this.k2 - y1) * (this.k2 - y1));
            if (k > n2) {
                return 1.0;
            }
            return k / n2;
        }
        double[] phi = GraphDrawHelper.getAngle((double)x1, (double)y1, (double)this.k1, (double)this.k2, (double)x2, (double)y2, (double)m[0], (double)m[1]);
        double phiA = phi[2];
        double phiC = phi[3];
        double phiK = phi[4];
        double d = phi[1];
        int n = phi[0] == phi[2] ? 1 : -1;
        if (d * (double)n > 0.0) {
            if (phiK < phiA) {
                phiK += 360.0;
            }
            if (phiC < phiK) {
                phiC += 360.0;
            }
            return (phiK - phiA) / (phiC - phiA);
        }
        if (phiK > phiA) {
            phiK -= 360.0;
        }
        if (phiC > phiK) {
            phiC -= 360.0;
        }
        return (phiK - phiA) / (phiC - phiA);
    }

    String getWS() {
        return this.ew.toString();
    }

    public boolean inYou(int x, int y) {
        if (this.icon == null) {
            this.icon = Edge.getTeXIcon(this.getWS(), (int)(16.0 * this.nl.getZoom()));
        }
        int TOLERANCE = 5;
        if (!Configuration.getInstance().getGeneralConfig().useJLaTeXMath()) {
            String s = this.getWS();
            FontRenderContext frc = this.g2d.getFontRenderContext();
            Rectangle2D rc = new Font("Arial", 0, (int)(16.0 * this.nl.getZoom())).getStringBounds(s, frc);
            return (double)x / this.nl.getZoom() > (double)this.k1 - rc.getWidth() / 2.0 - (double)TOLERANCE && (double)x / this.nl.getZoom() < (double)this.k1 + rc.getWidth() / 2.0 + (double)TOLERANCE && (double)y / this.nl.getZoom() < (double)this.k2 - rc.getHeight() * 1.0 / 2.0 + (double)TOLERANCE && (double)y / this.nl.getZoom() > (double)this.k2 - rc.getHeight() * 3.0 / 2.0 - (double)TOLERANCE;
        }
        return (double)x / this.nl.getZoom() > (double)(this.k1 - this.icon.getIconWidth() / 2 - TOLERANCE) && (double)x / this.nl.getZoom() < (double)(this.k1 + this.icon.getIconWidth() / 2 + TOLERANCE) && (double)y / this.nl.getZoom() < (double)(this.k2 + this.icon.getIconHeight() / 2 + TOLERANCE) && (double)y / this.nl.getZoom() > (double)(this.k2 - this.icon.getIconHeight() / 2 - TOLERANCE);
    }

    public void paintEdge(Graphics g) {
        int x1 = this.from.x + Node.getRadius();
        int x2 = this.to.x + Node.getRadius();
        int y1 = this.from.y + Node.getRadius();
        int y2 = this.to.y + Node.getRadius();
        if (this.from != this.to) {
            int dx = x1 - this.k1;
            int dy = y1 - this.k2;
            double d = Math.sqrt(dx * dx + dy * dy);
            x1 -= (int)((double)(Node.getRadius() * dx) / d);
            y1 -= (int)((double)(Node.getRadius() * dy) / d);
            dx = this.k1 - x2;
            dy = this.k2 - y2;
            d = Math.sqrt(dx * dx + dy * dy);
            x2 += (int)((double)(Node.getRadius() * dx) / d);
            y2 += (int)((double)(Node.getRadius() * dy) / d);
            if (this.g2d == null) {
                this.g2d = (Graphics2D)g;
            }
            this.g2d = (Graphics2D)g;
            GraphDrawHelper.drawEdge((Graphics)g, (double)((int)((double)x1 * this.nl.getZoom())), (double)((int)((double)y1 * this.nl.getZoom())), (double)((int)((double)this.k1 * this.nl.getZoom())), (double)((int)((double)this.k2 * this.nl.getZoom())), (double)((int)((double)x2 * this.nl.getZoom())), (double)((int)((double)y2 * this.nl.getZoom())), (int)((int)(8.0 * this.nl.getZoom())), (int)35, (boolean)true);
        }
    }

    public void paintEdgeLabel(Graphics g) {
        this.g2d.setFont(new Font("Arial", 0, (int)(16.0 * this.nl.getZoom())));
        this.frc = this.g2d.getFontRenderContext();
        String s = this.getWS();
        if (!Configuration.getInstance().getGeneralConfig().useJLaTeXMath()) {
            Rectangle2D rc = this.g2d.getFont().getStringBounds(s, this.frc);
            this.g2d.setColor(new Color(0.99f, 0.99f, 0.99f));
            this.g2d.fillRect((int)((double)this.k1 * this.nl.getZoom() - rc.getWidth() / 2.0), (int)((double)this.k2 * this.nl.getZoom() - rc.getHeight() * 3.0 / 2.0), (int)(rc.getWidth() + 5.0), (int)(rc.getHeight() + 5.0));
            this.g2d.setColor(Color.BLACK);
            this.g2d.drawString(s, (float)((double)this.k1 * this.nl.getZoom() - rc.getWidth() / 2.0), (float)((double)this.k2 * this.nl.getZoom() - rc.getHeight() / 2.0));
        } else {
            if (this.icon == null || this.lastFontSize != (int)(16.0 * this.nl.getZoom())) {
                this.lastFontSize = (int)(16.0 * this.nl.getZoom());
                this.icon = Edge.getTeXIcon(s, this.lastFontSize);
            }
            this.g2d.setColor(new Color(0.99f, 0.99f, 0.99f));
            this.g2d.fillRect((int)((double)this.k1 * this.nl.getZoom() - (double)(this.icon.getIconWidth() / 2) - 5.0), (int)((double)this.k2 * this.nl.getZoom() - (double)(this.icon.getIconHeight() / 2) - 5.0), this.icon.getIconWidth() + 10, this.icon.getIconHeight() + 10);
            this.g2d.setColor(Color.BLACK);
            Stroke oldStroke = this.g2d.getStroke();
            this.g2d.setStroke(new BasicStroke(1.0f));
            this.g2d.drawRect((int)((double)this.k1 * this.nl.getZoom() - (double)(this.icon.getIconWidth() / 2) - 5.0), (int)((double)this.k2 * this.nl.getZoom() - (double)(this.icon.getIconHeight() / 2) - 5.0), this.icon.getIconWidth() + 10, this.icon.getIconHeight() + 10);
            this.g2d.setStroke(oldStroke);
            this.icon.paintIcon(panel, (Graphics)this.g2d, (int)((double)this.k1 * this.nl.getZoom() - (double)(this.icon.getIconWidth() / 2)), (int)((double)this.k2 * this.nl.getZoom() - (double)(this.icon.getIconHeight() / 2)));
        }
    }

    public static TeXIcon getTeXIcon(String s, int points) {
        boolean print = true;
        s.replaceAll("\u03b5", "\\varepsilon");
        String latex = "";
        while (s.length() > 0) {
            int i = Edge.getNextOperator(s);
            if (i != -1) {
                String op = "" + s.charAt(i);
                String start = s.substring(0, i);
                s = s.substring(i + 1, s.length());
                if (op.equals("+") || op.equals("-") || op.equals("*")) {
                    if (print) {
                        latex = latex + start;
                    }
                    if (!op.equals("*")) {
                        latex = latex + op;
                    }
                    print = true;
                }
                if (!op.equals("/")) continue;
                i = Edge.getNextOperator(s);
                String s2 = i != -1 ? s.substring(0, i) : s;
                if (op.equals("/")) {
                    latex = latex + "\\frac{" + start + "}{" + s2 + "}";
                }
                print = false;
                continue;
            }
            if (print) {
                latex = latex + s;
            }
            s = "";
        }
        logger.debug((Object)("LaTeX string:" + latex));
        TeXFormula formula = new TeXFormula(latex);
        formula = new TeXFormula("\\mathbf{" + latex + "}");
        return formula.createTeXIcon(2, (float)points);
    }

    private static int getNextOperator(String s) {
        int min = s.length() + 1;
        int i = s.indexOf("+");
        if (i != -1) {
            min = i;
        }
        if ((i = s.indexOf("-")) != -1 && min > i) {
            min = i;
        }
        if ((i = s.indexOf("*")) != -1 && min > i) {
            min = i;
        }
        if ((i = s.indexOf("/")) != -1 && min > i) {
            min = i;
        }
        if (min == s.length() + 1) {
            return -1;
        }
        return min;
    }

    public void setK1(int k1) {
        double correction = 0.0;
        this.k1 = k1 + (int)correction;
        if (this.k1 < 0) {
            this.k1 = 0;
        }
    }

    public void setK2(int k2) {
        double correction = 0.0;
        if (this.frc != null) {
            Rectangle2D rc = this.g2d.getFont().getStringBounds(this.getWS(), this.frc);
            correction = rc.getHeight() / 2.0;
        }
        this.k2 = k2 + (int)correction;
        if (this.k2 < 0) {
            this.k2 = 0;
        }
    }

    public void setW(Double w) {
        this.ew = new EdgeWeight(w);
        this.icon = null;
        this.nl.repaint();
        this.nl.graphHasChanged();
    }

    public void setW(String text) {
        this.ew = new EdgeWeight(text);
        this.icon = null;
        this.nl.repaint();
        this.nl.graphHasChanged();
    }

    public String getWLaTeX() {
        return this.ew.getLaTeXStr();
    }

    public Collection<String> getVariable() {
        return this.ew.getVariables();
    }

    public double[] getW(Hashtable<String, Double> ht) {
        return this.ew.getWeight(ht);
    }

    public EdgeWeight getEdgeWeight() {
        return this.ew;
    }

    public String getEpsilonString(Hashtable<String, Double> ht) {
        double[] w = this.ew.getWeight(ht);
        if (w.length < 2) {
            return null;
        }
        String s = "c(";
        for (int i = 1; i < w.length; ++i) {
            s = s + w[i];
            if (i == w.length - 1) continue;
            s = s + ", ";
        }
        s = s + ")";
        return s;
    }
}

