/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.io.PrintStream;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.af.jhlir.backends.rengine.RCallServicesREngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.DebugTextConsole;
import org.mutoss.gui.ErrorDialogSGTK;
import org.mutoss.gui.LoggingOutputStream;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;

public class RControl {
    private static final Log logger = LogFactory.getLog(RControl.class);
    protected static RControl rc = null;
    protected static RCallServicesREngine rcs = null;
    public static DebugTextConsole console = null;

    public static RControl getRControl(boolean debug) {
        if (rc == null) {
            rc = new RControl(debug);
        }
        return rc;
    }

    public static RCallServicesREngine getR() {
        RControl.getRControl(true);
        return rcs;
    }

    protected RControl(boolean debug) {
        Rengine rengine;
        if (!LoggingSystem.alreadyInitiated()) {
            LoggingSystem.init((String)"/org/mutoss/gui/commons-logging.properties", (System.getProperty("eclipse") == null && !debug ? 1 : 0) != 0, (System.getProperty("eclipse") != null || debug ? 1 : 0) != 0, (ApplicationLog)new ApplicationLog());
            ErrorHandler.init((String)"rohmeyer@small-projects.de", (String)"http://www.algorithm-forge.com/report/bugreport.php", (boolean)true, (boolean)true, ErrorDialogSGTK.class);
        }
        if ((rengine = Rengine.getMainEngine()) == null) {
            if (System.getProperty("eclipse") != null) {
                console = new DebugTextConsole();
                rengine = new Rengine(new String[]{"--vanilla"}, true, (RMainLoopCallbacks)console);
            } else {
                rengine = new Rengine();
            }
        }
        try {
            rcs = new RCallServicesREngine((REngine)new JRIEngine(rengine));
            if (System.getProperty("eclipse") != null) {
                rcs.eval("require(gMCP)");
                rcs.eval("graph <- BonferroniHolmGraph(3)");
                rcs.eval("graph2 <- graphFromBretzEtAl2011()");
                rcs.eval("m <- matrix(0, nrow=2, ncol=2)");
                rcs.eval("dunnettM <- matrix(c(1,1/2,1/2,1), nrow=2)");
                rcs.eval("mu <- c(0.860382, 0.9161474, 0.9732953)");
                rcs.eval("sdEst <- c(0.8759528, 1.291310, 0.8570892)");
                rcs.eval("pval <- c(0.01260, 0.05154, 0.02124)/2");
            }
        }
        catch (REngineException e) {
            ErrorHandler.getInstance().makeErrDialog("Error creating RCallServicesREngine!", (Object)e);
        }
        if (System.getProperty("eclipse") == null && !debug) {
            System.setOut(new PrintStream(new LoggingOutputStream(logger), true));
        }
    }

    public static String getFraction(Double d, int cycles) {
        return RControl.getR().eval("as.character(fractions(" + d + (cycles == -1 ? "" : ", cycles=" + cycles) + "))").asRChar().getData()[0];
    }

    public static String getFraction(Double d, boolean useUnicode) {
        return RControl.getFraction(d, useUnicode, -1);
    }

    public static String getFraction(Double d, boolean useUnicode, int cycles) {
        String f = RControl.getFraction(d, cycles);
        return f;
    }

    public static String getFraction(Double d) {
        return RControl.getFraction(d, -1);
    }

    public static boolean exists(String obj) {
        return RControl.getR().eval("exists(\"" + obj + "\")").asRLogical().getData()[0];
    }
}

