/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.VariableDialog;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.GraphMCP;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.UpdateEdge;
import org.af.gMCP.gui.graph.UpdateNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetList
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final Log logger = LogFactory.getLog(NetList.class);
    GraphView control;
    int drag = -1;
    int edrag = -1;
    protected Vector<Edge> edges = new Vector();
    protected Vector<Node> nodes = new Vector();
    Node firstVertex;
    boolean firstVertexSelected = false;
    public String initialGraph = ".InitialGraph" + new Date().getTime();
    boolean newEdge = false;
    boolean newVertex = false;
    JLabel statusBar;
    public boolean testingStarted = false;
    double zoom = 1.0;
    static DecimalFormat format = new DecimalFormat("#.####");
    public boolean updateGUI = true;
    protected int[] offset;
    Double expRejections = null;
    Double powAtlst1 = null;
    Double rejectAll = null;
    Double userDefined = null;

    public NetList(JLabel statusBar, GraphView graphview) {
        this.statusBar = statusBar;
        this.control = graphview;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        Font f = statusBar.getFont();
        statusBar.setFont(f.deriveFont(f.getStyle() ^ 1));
    }

    public void acceptNode(Node node) {
        this.control.getPView().savePValues();
        this.saveGraph(".tmpGraph", false);
        RControl.getR().eval(".tmpGraph <- substituteEps(.tmpGraph, eps=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ")");
        RControl.getR().eval(".tmpGraph <- rejectNode(.tmpGraph, \"" + node.getName() + "\")");
        this.reset();
        new GraphMCP(".tmpGraph", this);
        this.control.getPView().restorePValues();
    }

    public void addDefaultNode(int x, int y) {
        int i = this.nodes.size() + 1;
        String name = "H" + i;
        while (this.whichNode(name) != -1) {
            name = "H" + ++i;
        }
        this.addNode(new Node(name, x, y, 0.0, this));
    }

    public void setEdge(Edge e) {
        Edge old = null;
        for (Edge e2 : this.edges) {
            if (e2.from == e.from && e2.to == e.to) {
                old = e2;
            }
            if (e2.from != e.to || e2.to != e.from) continue;
            e.curve = true;
            e2.curve = true;
        }
        if (old != null) {
            this.edges.remove(old);
        }
        this.edges.add(e);
        this.control.getDataTable().getModel().setValueAt(e.getEdgeWeight(), this.getNodes().indexOf(e.from), this.getNodes().indexOf(e.to));
        this.graphHasChanged();
    }

    public void setEdge(Node von, Node nach) {
        this.setEdge(von, nach, 1.0);
    }

    public void setEdge(Node von, Node nach, Double w) {
        this.setEdge(von, nach, new EdgeWeight(w));
    }

    public void setEdge(Node von, Node nach, EdgeWeight w) {
        Integer x = null;
        Integer y = null;
        boolean curve = false;
        for (Edge e : this.edges) {
            if (e.from != nach || e.to != von) continue;
            e.curve = true;
            curve = true;
        }
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            if (this.edges.get((int)i).from != von || this.edges.get((int)i).to != nach) continue;
            x = this.edges.get(i).getK1();
            y = this.edges.get(i).getK2();
            this.edges.remove(i);
        }
        if (!w.toString().equals("0")) {
            if (x != null) {
                this.edges.add(new Edge(von, nach, w, this, (int)x, (int)y));
            } else {
                this.edges.add(new Edge(von, nach, w, this, curve));
            }
            this.edges.lastElement().curve = curve;
        }
        this.control.getDataTable().getModel().setValueAt(w, this.getNodes().indexOf(von), this.getNodes().indexOf(nach));
        this.graphHasChanged();
    }

    public void addNode(Node node) {
        this.control.enableButtons(true);
        this.nodes.add(node);
        this.control.getPView().addPPanel(node);
        this.control.getDataTable().getModel().addRowCol(node.getName());
        this.calculateSize();
        this.graphHasChanged();
    }

    public void graphHasChanged() {
        this.control.resultUpToDate = false;
        if (!this.updateGUI) {
            return;
        }
        String analysis = null;
        Set<String> variables = this.getAllVariables();
        variables.remove("\u03b5");
        if (variables.size() == 0) {
            try {
                String graphName = ".tmpGraph" + new Date().getTime();
                this.saveGraph(graphName, false);
                analysis = RControl.getR().eval("graphAnalysis(" + graphName + ", file=tempfile())").asRChar().getData()[0];
            }
            catch (Exception exception) {}
        } else {
            analysis = "Graphs with variables are not yet supported for analysis.";
        }
        this.control.getDView().setAnalysis(analysis);
    }

    public int[] calculateSize() {
        int i;
        int maxX = 0;
        int maxY = 0;
        for (i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getX() > maxX) {
                maxX = this.nodes.get(i).getX();
            }
            if (this.nodes.get(i).getY() <= maxY) continue;
            maxY = this.nodes.get(i).getY();
        }
        for (i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i).getK1() > maxX) {
                maxX = this.edges.get(i).getK1();
            }
            if (this.edges.get(i).getK2() <= maxY) continue;
            maxY = this.edges.get(i).getK2();
        }
        this.setPreferredSize(new Dimension((int)((double)(maxX + 2 * Node.getRadius() + 30) * this.getZoom()), (int)((double)(maxY + 2 * Node.getRadius() + 30) * this.getZoom())));
        if (this.updateGUI) {
            this.revalidate();
            this.repaint();
        }
        return new int[]{maxX, maxY};
    }

    public Edge findEdge(Node von, Node nach) {
        for (Edge e : this.edges) {
            if (von != e.from || nach != e.to) continue;
            return e;
        }
        return null;
    }

    public Vector<Edge> getEdges() {
        return this.edges;
    }

    public BufferedImage getImage() {
        long maxX = 0L;
        long maxY = 0L;
        for (Node node : this.nodes) {
            if ((long)node.getX() > maxX) {
                maxX = node.getX();
            }
            if ((long)node.getY() <= maxY) continue;
            maxY = node.getY();
        }
        for (Edge edge : this.edges) {
            if ((long)edge.getK1() > maxX) {
                maxX = edge.getK1();
            }
            if ((long)edge.getK2() <= maxY) continue;
            maxY = edge.getK2();
        }
        BufferedImage img = new BufferedImage((int)((double)(maxX + (long)(2 * Node.getRadius()) + 10L) * this.getZoom()), (int)((double)(maxY + (long)(2 * Node.getRadius()) + 10L) * this.getZoom()), 2);
        Graphics2D g = img.createGraphics();
        g.setStroke(new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.nodes) {
            node.paintYou(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdge(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdgeLabel(g);
        }
        return img;
    }

    public Vector<Node> getNodes() {
        return this.nodes;
    }

    public String getLaTeX() {
        int i;
        DecimalFormat format = Configuration.getInstance().getGeneralConfig().getDecFormat();
        String latex = "";
        double scale = 0.5;
        latex = latex + "\\begin{tikzpicture}[scale=" + scale + "]";
        for (i = 0; i < this.getNodes().size(); ++i) {
            Node node = this.getNodes().get(i);
            latex = latex + "\\node (" + node.getName().replace("_", "-") + ") at (" + node.getX() + "bp," + -node.getY() + "bp)\n";
            String nodeColor = "green!80";
            if (node.isRejected()) {
                nodeColor = "red!80";
            }
            latex = latex + "[draw,circle split,fill=" + nodeColor + "] {$" + node.getName() + "$ \\nodepart{lower} $" + format.format(node.getWeight()) + "$};\n";
        }
        for (i = 0; i < this.getEdges().size(); ++i) {
            Node node1 = this.getEdges().get((int)i).from;
            Node node2 = this.getEdges().get((int)i).to;
            String to = "bend left=" + this.getEdges().get(i).getBendLeft();
            String weight = this.getEdges().get(i).getWLaTeX();
            String pos = format.format(this.getEdges().get(i).getPos()).replace(",", ".");
            latex = latex + "\\draw [->,line width=1pt] (" + node1.getName().replace("_", "-") + ") to[" + to + "] node[pos=" + pos + ",above,fill=blue!20] {$" + weight + "$} (" + node2.getName().replace("_", "-") + ");\n";
        }
        latex = latex + "\\end{tikzpicture}\n\n";
        return latex;
    }

    public double getZoom() {
        return this.zoom;
    }

    public boolean isTesting() {
        return this.testingStarted;
    }

    public GraphMCP loadGraph() {
        this.control.stopTesting();
        this.reset();
        this.updateGUI = false;
        GraphMCP graph = new GraphMCP(this.initialGraph, this);
        this.control.getPView().restorePValues();
        this.updateGUI = true;
        this.graphHasChanged();
        this.revalidate();
        this.repaint();
        return graph;
    }

    public void loadGraph(String string) {
        boolean matrix = RControl.getR().eval("is.matrix(" + string + ")").asRLogical().getData()[0];
        RControl.getR().eval(this.initialGraph + " <- placeNodes(" + (matrix ? "matrix2graph(" : "(") + string + "))");
        GraphMCP graph = this.loadGraph();
        if (graph.getDescription() != null) {
            this.control.getDView().setDescription(graph.getDescription());
        } else {
            this.control.getDView().setDescription("");
        }
        if (graph.pvalues != null && graph.pvalues.length > 1) {
            this.control.getPView().setPValues(graph.pvalues);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.drag == -1 && this.edrag == -1) {
            return;
        }
        if (this.drag != -1) {
            this.nodes.get(this.drag).setX((int)((double)(e.getX() + this.offset[0]) / this.getZoom()));
            this.nodes.get(this.drag).setY((int)((double)(e.getY() + this.offset[1]) / this.getZoom()));
            this.placeUnfixedNodes(this.nodes.get(this.drag));
        } else {
            this.edges.get(this.edrag).setK1((int)((double)(e.getX() + this.offset[0]) / this.getZoom()));
            this.edges.get(this.edrag).setK2((int)((double)(e.getY() + this.offset[1]) / this.getZoom()));
        }
        this.calculateSize();
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int i;
        if (this.newVertex) {
            this.addDefaultNode((int)((double)e.getX() / this.getZoom()) - Node.r, (int)((double)e.getY() / this.getZoom()) - Node.r);
            this.newVertex = false;
            this.statusBar.setText("Place new nodes and edges or start the test procedure");
            this.repaint();
            return;
        }
        if (this.newEdge) {
            if (!this.firstVertexSelected) {
                this.firstVertex = this.vertexSelected(e.getX(), e.getY());
                if (this.firstVertex == null) {
                    return;
                }
                this.firstVertexSelected = true;
                this.statusBar.setText("Select a second node to which the edge should lead.");
            } else {
                Node secondVertex = this.vertexSelected(e.getX(), e.getY());
                if (secondVertex == null || secondVertex == this.firstVertex) {
                    return;
                }
                this.setEdge(this.firstVertex, secondVertex);
                this.newEdge = false;
                this.firstVertexSelected = false;
                this.statusBar.setText("Place new nodes and edges or start the test procedure");
            }
            this.repaint();
            return;
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
            this.drag = i;
            this.offset = this.nodes.get(i).offset(e.getX(), e.getY());
        }
        for (i = this.edges.size() - 1; i >= 0; --i) {
            if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
            this.drag = -1;
            this.edrag = i;
            this.offset = this.edges.get(i).offset(e.getX(), e.getY());
        }
        if (e.getClickCount() == 2 && !this.testingStarted) {
            for (i = this.edges.size() - 1; i >= 0; --i) {
                if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateEdge(this.edges.get(i), this, this.control);
                this.repaint();
                return;
            }
            for (i = this.nodes.size() - 1; i >= 0; --i) {
                if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateNode(this.nodes.get(i), this);
                this.repaint();
                return;
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.edrag != -1) {
            this.edges.get(this.edrag).setFixed(true);
        }
        this.drag = -1;
        this.edrag = -1;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        g.setColor(Color.LIGHT_GRAY);
        if (grid > 1) {
            for (int x = -Node.r / grid * grid; x < this.getWidth(); x += grid) {
                g.drawLine(x + Node.r, 0, x + Node.r, this.getHeight());
            }
            for (int y = -Node.r / grid * grid; y < this.getHeight(); y += grid) {
                g.drawLine(0, y + Node.r, this.getWidth(), y + Node.r);
            }
        }
        BasicStroke stroke = new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth());
        ((Graphics2D)g).setStroke(stroke);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.nodes) {
            node.paintYou(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdge(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdgeLabel(g);
        }
        if (this.expRejections != null && this.powAtlst1 != null && this.rejectAll != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setFont(new Font("Arial", 1, (int)(12.0 * this.getZoom())));
            String s = "Expected number of rejections: " + format.format(this.expRejections);
            g2d.drawString(s, (float)(10.0 * this.getZoom()), (float)(20.0 * this.getZoom()));
            s = "Prob. to reject at least one hyp.: " + format.format(this.powAtlst1);
            g2d.drawString(s, (float)(10.0 * this.getZoom()), (float)(50.0 * this.getZoom()));
            s = "Prob. to reject all hypotheses: " + format.format(this.rejectAll);
            g2d.drawString(s, (float)(10.0 * this.getZoom()), (float)(80.0 * this.getZoom()));
            if (this.userDefined != null) {
                s = "User defined Power: " + format.format(this.userDefined);
                g2d.drawString(s, (float)(10.0 * this.getZoom()), (float)(110.0 * this.getZoom()));
            }
        }
    }

    public void refresh() {
        this.calculateSize();
        this.revalidate();
        this.repaint();
    }

    public void removeEdge(Edge edge) {
        logger.info((Object)("Removing " + edge));
        for (Edge e : this.edges) {
            if (e.from != edge.to || e.to != edge.from) continue;
            e.curve = false;
        }
        this.edges.remove(edge);
        this.control.getDataTable().getModel().setValueAt(new EdgeWeight(0.0), this.getNodes().indexOf(edge.from), this.getNodes().indexOf(edge.to));
        this.graphHasChanged();
    }

    public void removeNode(Node node) {
        logger.info((Object)("Removing " + node));
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            Edge e = this.edges.get(i);
            if (e.from != node && e.to != node) continue;
            this.edges.remove(e);
        }
        this.control.getDataTable().getModel().delRowCol(this.getNodes().indexOf(node));
        this.nodes.remove(node);
        this.control.getPView().removePPanel(node);
        if (this.nodes.size() == 0) {
            this.control.enableButtons(false);
        }
        this.repaint();
        this.graphHasChanged();
    }

    public void reset() {
        logger.info((Object)"Reset.");
        this.edges.removeAllElements();
        for (int i = this.getNodes().size() - 1; i >= 0; --i) {
            this.removeNode(this.getNodes().get(i));
        }
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
        this.firstVertexSelected = false;
        this.newVertex = false;
        this.newEdge = false;
        this.zoom = 1.0;
        this.control.getDView().setDescription("Enter a description for the graph.");
        this.graphHasChanged();
    }

    public void saveGraph() {
        this.saveGraph(this.initialGraph, false);
        this.control.getPView().savePValues();
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (Edge e : this.edges) {
            variables.addAll(e.getVariable());
        }
        return variables;
    }

    public String saveGraphWithoutVariables(String graphName, boolean verbose) {
        Set<String> variables = this.getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        Hashtable<String, Double> ht = new Hashtable<String, Double>();
        if (!(variables.isEmpty() || variables.size() == 1 && variables.contains("\u03b5"))) {
            VariableDialog vd = new VariableDialog(this.control.parent, variables);
            ht = vd.getHT();
        } else if (variables.size() == 1 && variables.contains("\u03b5")) {
            ht.put("\u03b5", Configuration.getInstance().getGeneralConfig().getEpsilon());
        }
        graphName = RControl.getR().eval("make.names(\"" + graphName + "\")").asRChar().getData()[0];
        this.saveGraph(graphName, verbose, null);
        RControl.getR().eval(graphName + "<- gMCP:::replaceVariables(" + graphName + ", variables=" + this.getRVariableList(ht) + ")");
        this.loadGraph(graphName);
        return this.saveGraph(graphName, verbose, ht);
    }

    public String saveGraph(String graphName, boolean verbose) {
        return this.saveGraph(graphName, verbose, new Hashtable<String, Double>());
    }

    public String getRVariableList(Hashtable<String, Double> ht) {
        String list = "list(";
        Enumeration<String> keys = ht.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            list = list + "\"" + EdgeWeight.UTF2LaTeX(key.charAt(0)) + "\"=" + ht.get(key) + ",";
        }
        list = list + "\"epsilon\"=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ",";
        return list.substring(0, list.length() > 5 ? list.length() - 1 : list.length()) + ")";
    }

    public String saveGraph(String graphName, boolean verbose, Hashtable<String, Double> ht) {
        graphName = RControl.getR().eval("make.names(\"" + graphName + "\")").asRChar().getData()[0];
        String alpha = "";
        String nodeStr = "";
        String x = "";
        String y = "";
        for (Node n : this.nodes) {
            alpha = alpha + n.getWeight() + ",";
            nodeStr = nodeStr + "\"" + n.getName() + "\",";
            x = x + n.getX() + ",";
            y = y + n.getY() + ",";
        }
        alpha = alpha.substring(0, alpha.length() - 1);
        nodeStr = nodeStr.substring(0, nodeStr.length() - 1);
        x = x.substring(0, x.length() - 1);
        y = y.substring(0, y.length() - 1);
        RControl.getR().evalVoid(".gsrmtVar <- list()");
        RControl.getR().evalVoid(".gsrmtVar$alpha <- c(" + alpha + ")");
        RControl.getR().evalVoid(".gsrmtVar$hnodes <- c(" + nodeStr + ")");
        RControl.getR().evalVoid(".gsrmtVar$m <- matrix(0, nrow=" + this.nodes.size() + ", ncol=" + this.nodes.size() + ")");
        RControl.getR().evalVoid("rownames(.gsrmtVar$m) <- colnames(.gsrmtVar$m) <- .gsrmtVar$hnodes");
        for (Edge e : this.edges) {
            RControl.getR().evalVoid(".gsrmtVar$m[\"" + e.from.getName() + "\",\"" + e.to.getName() + "\"] <- \"" + e.getWS().replaceAll("\\\\", "\\\\\\\\") + "\"");
        }
        RControl.getR().evalVoid(graphName + " <- new(\"graphMCP\", m=.gsrmtVar$m, weights=.gsrmtVar$alpha)");
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            Node n;
            n = this.nodes.get(i);
            if (!n.isRejected()) continue;
            RControl.getR().evalVoid("nodeAttr(" + graphName + ", \"" + n.getName() + "\", \"rejected\") <- TRUE");
        }
        RControl.getR().evalVoid(graphName + "@nodeAttr$X <- c(" + x + ")");
        RControl.getR().evalVoid(graphName + "@nodeAttr$Y <- c(" + y + ")");
        for (Edge e : this.edges) {
            RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"labelX\") <- " + (e.k1 - Node.getRadius()));
            RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"labelY\") <- " + (e.k2 - Node.getRadius()));
            if (Double.valueOf(e.getW(ht)).isNaN()) {
                RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"variableWeight\") <- \"" + e.getWS().replaceAll("\\\\", "\\\\\\\\") + "\"");
            }
            if (e.getW(ht) != 0.0) continue;
            RControl.getR().evalVoid(graphName + "@m[\"" + e.from.getName() + "\", \"" + e.to.getName() + "\"] <- 0");
        }
        RControl.getR().evalVoid("attr(" + graphName + ", \"description\") <- \"" + this.control.getDView().getDescription() + "\"");
        if (verbose) {
            JOptionPane.showMessageDialog(null, "The graph as been exported to R under ther variable name:\n\n" + graphName, "Saved as \"" + graphName + "\"", 1);
        }
        return graphName;
    }

    public void setEdges(Vector<Edge> edges) {
        this.edges = edges;
        this.graphHasChanged();
    }

    public void setKnoten(Vector<Node> knoten) {
        this.nodes = knoten;
        this.graphHasChanged();
    }

    public void setZoom(double p) {
        this.zoom = p;
    }

    public void startTesting() {
        this.testingStarted = true;
        this.statusBar.setText("Reject nodes or reset to the initial graph for modifications.");
    }

    public void stopTesting() {
        this.testingStarted = false;
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
    }

    public Node vertexSelected(int x, int y) {
        for (Node n : this.nodes) {
            if (!n.inYou(x, y)) continue;
            return n;
        }
        return null;
    }

    public int whichNode(String name) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public String getGraphName() {
        this.saveGraph(".tmpGraph", false);
        return ".tmpGraph";
    }

    public void setPower(double[] localPower, Double expRejections, Double powAtlst1, Double rejectAll, Double userDefined) {
        for (int i = 0; i < localPower.length; ++i) {
            this.nodes.get(i).setLocalPower(localPower[i]);
        }
        this.expRejections = expRejections;
        this.powAtlst1 = powAtlst1;
        this.rejectAll = rejectAll;
        this.userDefined = userDefined;
        this.repaint();
    }

    private void placeUnfixedNodes(Node node) {
        for (Edge e : this.edges) {
            if (e.from != node && e.to != node || e.isFixed()) continue;
            e.move();
        }
    }
}

