/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.af.commons.io.FileTools;

public class TextFileViewer
extends JDialog
implements ActionListener {
    JTextArea jta;

    public TextFileViewer(JFrame p, File file) {
        super((Frame)p, file.getName());
        String text;
        try {
            text = FileTools.readFileAsString((File)file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(p, "File \"" + file.getAbsolutePath() + "\" not found!", "File not found", 0);
            this.dispose();
            return;
        }
        this.setUp(text, null);
    }

    public TextFileViewer(JFrame p, String title, String text) {
        super((Frame)p, title);
        this.setUp(text, null);
    }

    public TextFileViewer(JFrame p, String title, String text, String label) {
        super((Frame)p, title);
        this.setUp(text, label);
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void setUp(String text, String label) {
        this.jta = new JTextArea(text);
        this.jta.setFont(new Font("Monospaced", 0, 12));
        this.jta.setLineWrap(true);
        this.jta.setWrapStyleWord(true);
        String cols = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, fill:200dlu:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        JScrollPane jsp = new JScrollPane(this.jta);
        this.getContentPane().add((Component)jsp, cc.xyw(2, 2, 3));
        if (label != null) {
            JTextArea jlabel = new JTextArea(label);
            jlabel.setOpaque(false);
            jlabel.setEditable(false);
            this.getContentPane().add((Component)jlabel, cc.xyw(2, 4, 3));
        }
        JButton jb = new JButton("OK");
        jb.addActionListener(this);
        this.getContentPane().add((Component)jb, cc.xy(4, 6));
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

