/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.af.commons.widgets.RightClickTextMenuListener;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.jhlir.call.RDataFrame;

public class PowerResultDialog
extends JDialog
implements ActionListener {
    public String NEW_CELL = "\t";
    public String NEW_LINE = "\n";
    JButton jbCopyTable = new JButton("Copy Table to Clipboard");
    JButton jbCopyText = new JButton("Copy Text to Clipboard");
    JButton jbOk = new JButton("Ok");
    Object[][] data;
    String[] colnames;
    JTextArea jta = new JTextArea();

    public PowerResultDialog(CreateGraphGUI parent, String title, RDataFrame result, String[] colnames, String command, Class c) {
        super((Frame)parent, title);
        this.colnames = colnames;
        this.data = new Object[result.getRowCount()][result.getColumnCount()];
        for (int i = 0; i < result.getRowCount(); ++i) {
            for (int j = 0; j < result.getColumnCount(); ++j) {
                this.data[i][j] = result.get(i, j);
            }
        }
        DefaultTableModel object = new DefaultTableModel(this.data, colnames);
        try {
            Constructor ct = c.getConstructor(Object[][].class, String[].class);
            object = ct.newInstance(new Object[]{this.data, colnames});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JTable jt = new JTable(object);
        jt.setAutoCreateRowSorter(true);
        jt.setAutoResizeMode(0);
        String cols = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        JScrollPane jsp = new JScrollPane(jt);
        int row = 2;
        this.jta.setText(command);
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.jta.setFont(new Font("Monospaced", 0, 12));
        this.jta.setLineWrap(false);
        this.jta.addMouseListener((MouseListener)new RightClickTextMenuListener((JTextComponent)this.jta));
        JSplitPane splitPane = new JSplitPane(0, jsp, new JScrollPane(this.jta));
        this.getContentPane().add((Component)splitPane, cc.xywh(2, row, 7, 3));
        row += 2;
        this.jbCopyTable.addActionListener(this);
        this.jbCopyText.addActionListener(this);
        this.jbOk.addActionListener(this);
        this.getContentPane().add((Component)this.jbCopyTable, cc.xy(4, row += 2));
        this.getContentPane().add((Component)this.jbCopyText, cc.xy(6, row));
        this.getContentPane().add((Component)this.jbOk, cc.xy(8, row));
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public void copyTableToClipboard() {
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < this.colnames.length; ++j) {
            s.append(this.colnames[j] + this.NEW_CELL);
        }
        s.append(this.NEW_LINE);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                s.append(this.data[i][j].toString() + this.NEW_CELL);
            }
            s.append(this.NEW_LINE);
        }
        StringSelection stringTable = new StringSelection(s.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringTable, stringTable);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbOk) {
            this.dispose();
        }
        if (e.getSource() == this.jbCopyTable) {
            this.copyTableToClipboard();
        }
        if (e.getSource() == this.jbCopyText) {
            StringSelection stringText = new StringSelection(this.jta.getText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringText, stringText);
        }
    }
}

