/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.ReproducableLog;
import org.af.gMCP.gui.dialogs.VariableDialog;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.GraphMCP;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.LaTeXTool;
import org.af.gMCP.gui.graph.NetListPanel;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.annotations.Annotation;
import org.af.gMCP.gui.graph.annotations.AnnotationPanel;
import org.af.gMCP.gui.graph.annotations.Legend;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetList
extends JTabbedPane
implements ChangeListener,
AnnotationPanel {
    private static final Log logger = LogFactory.getLog(NetList.class);
    GraphView control;
    protected Vector<Node> nodes = new Vector();
    protected Vector<Edge> edges = new Vector();
    protected Vector<Annotation> annotations = new Vector();
    public GraphMCP graph;
    public List<NetListPanel> nlp = new Vector<NetListPanel>();
    public String resetGraph = ".ResetGraph" + new Date().getTime();
    public String tmpGraph = ".tmpGraph" + new Date().getTime();
    public String initialGraph = ".InitialGraph" + new Date().getTime();
    JLabel statusBar;
    Legend entangledLegend = null;
    public boolean testingStarted = false;
    private int layer = 1;
    public boolean updateGUI = true;
    double zoom = 1.0;
    int oldi = -1;
    int oldj = -1;
    Integer oldLinewidth = null;

    public NetList(JLabel statusBar, GraphView graphview) {
        this.addChangeListener(this);
        this.statusBar = statusBar;
        this.control = graphview;
        Font f = statusBar.getFont();
        statusBar.setFont(f.deriveFont(f.getStyle() ^ 1));
        this.nlp.add(new NetListPanel(this, null));
        this.addTab("Graph", this.nlp.get(0));
    }

    public void acceptNode(Node node) {
        this.control.getPView().savePValues();
        this.saveGraph(".tmpGraph", false, false);
        RControl.getR().eval(".tmpGraph <- substituteEps(.tmpGraph, eps=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ")");
        ReproducableLog.logR(RControl.getR().eval("gMCP:::dputGraph(.tmpGraph, \".tmpGraph\")").asRChar().getData()[0]);
        RControl.evalAndLog(".tmpGraph <- rejectNode(.tmpGraph, \"" + node.getName() + "\", upscale = " + (Configuration.getInstance().getGeneralConfig().getUpscale() ? "TRUE" : "FALSE") + ")");
        this.reset();
        new GraphMCP(".tmpGraph", this);
        this.control.getPView().restorePValues();
    }

    public void addDefaultNode(int x, int y) {
        int i = this.nodes.size() + 1;
        String name = "H" + i;
        while (this.whichNode(name) != -1) {
            name = "H" + ++i;
        }
        double[] weights = new double[this.layer];
        this.addNode(new Node(name, x, y, weights, this));
    }

    public Point getMaxPoint() {
        int maxX = 0;
        int maxY = 0;
        for (Node node : this.getNodes()) {
            if (node.getX() > maxX) {
                maxX = node.getX();
            }
            if (node.getY() <= maxY) continue;
            maxY = node.getY();
        }
        for (Edge edge : this.getEdges()) {
            if (edge.getK1() > maxX) {
                maxX = edge.getK1();
            }
            if (edge.getK2() <= maxY) continue;
            maxY = edge.getK2();
        }
        return new Point(maxX, maxY);
    }

    public void placeEntangledLegend() {
        if (this.entangledLegend != null) {
            Point p = this.getMaxPoint();
            this.entangledLegend.setX(100);
            this.entangledLegend.setY((int)p.getY() + 100);
        }
    }

    public void addEntangledLayer() {
        if (this.layer == 1) {
            this.setTitleAt(0, "Combined");
            this.nlp.add(new NetListPanel(this, 0));
            this.addTab("Graph 1", this.nlp.get(this.nlp.size() - 1));
        }
        this.nlp.add(new NetListPanel(this, this.layer));
        ++this.layer;
        this.addTab("Graph " + this.layer, this.nlp.get(this.nlp.size() - 1));
        for (Node n : this.nodes) {
            n.addLayer();
        }
        Vector<String> vl = new Vector<String>();
        vl.add("Component Weights");
        for (int i = 0; i < this.layer; ++i) {
            String weight = "";
            try {
                weight = this.control.getPView().entangledWeights.get(i).getText();
            }
            catch (Exception exception) {
                // empty catch block
            }
            vl.add("Component Graph " + (i + 1) + ": " + weight);
        }
        int x = -1;
        int y = -1;
        if (this.entangledLegend != null) {
            x = this.entangledLegend.getX();
            y = this.entangledLegend.getY();
        } else {
            Point p = this.getMaxPoint();
            x = 100;
            y = (int)p.getY() + 50;
        }
        this.annotations.remove(this.entangledLegend);
        Color[] colors = new Color[this.layer + 1];
        colors[0] = Color.BLACK;
        for (int i = 1; i < this.layer + 1; ++i) {
            colors[i] = NetListPanel.layerColors[(i - 1) % NetListPanel.layerColors.length];
        }
        this.entangledLegend = new Legend(x, y, vl, Arrays.asList(colors), this);
        this.annotations.add(this.entangledLegend);
        this.refresh();
    }

    public void addNode(Node node) {
        this.control.enableButtons(true);
        this.nodes.add(node);
        this.control.getPView().addPPanel(node);
        this.control.getDataFramePanel().addRowCol(node.getName());
        this.calculateSize();
        this.graphHasChanged();
    }

    private int askForLayer() {
        int layer = 0;
        if (this.control.getNumberOfLayers() > 1) {
            layer = this.control.getDataFramePanel().getSelectedIndex();
        }
        return layer;
    }

    private void calculateSize() {
        for (NetListPanel n : this.nlp) {
            n.calculateSize();
        }
    }

    public Edge findEdge(Node von, Node nach, int layer) {
        for (Edge e : this.edges) {
            if (von != e.from || nach != e.to || e.layer != layer) continue;
            return e;
        }
        return null;
    }

    public NetListPanel getActiveNLP() {
        return this.nlp.get(this.getSelectedIndex());
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (Edge e : this.edges) {
            variables.addAll(e.getVariable());
        }
        return variables;
    }

    public Vector<Edge> getEdges() {
        return this.edges;
    }

    public String getGraphName() {
        this.saveGraph(".tmpGraph", false, false);
        return ".tmpGraph";
    }

    public BufferedImage getImage(Double d, boolean color) {
        return this.nlp.get(this.getSelectedIndex()).getImage(d, color, true, true, true);
    }

    public BufferedImage getImage(double d, boolean color, boolean drawHypNames, boolean drawHypWeights, boolean drawEdgeWeights) {
        return this.nlp.get(this.getSelectedIndex()).getImage(d, color, drawHypNames, drawHypWeights, drawEdgeWeights);
    }

    public String getLaTeX() {
        this.saveGraph(this.tmpGraph, false, false);
        return RControl.getR().eval("graph2latex(" + this.tmpGraph + ")").asRChar().getData()[0];
    }

    public Vector<Node> getNodes() {
        return this.nodes;
    }

    public String getRVariableList(Hashtable<String, Double> ht) {
        String list = "list(";
        Enumeration<String> keys = ht.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            list = list + "\"" + LaTeXTool.UTF2LaTeX(key.charAt(0)) + "\"=" + ht.get(key) + ",";
        }
        list = list + "\"epsilon\"=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ",";
        return list.substring(0, list.length() > 5 ? list.length() - 1 : list.length()) + ")";
    }

    @Override
    public double getZoom() {
        return this.zoom;
    }

    public void graphHasChanged() {
        this.control.setResultUpToDate(false);
        this.control.isGraphSaved = false;
        if (!this.updateGUI) {
            return;
        }
        String analysis = null;
        Set<String> variables = this.getAllVariables();
        variables.remove("\u03b5");
        if (variables.size() == 0) {
            try {
                String graphName = ".tmpGraph" + new Date().getTime();
                this.saveGraph(graphName, false, false);
                if (this.control.getDView().getSelectedIndex() == 1) {
                    System.out.println("Performing graph Analysis");
                    analysis = RControl.getR().eval("graphAnalysis(" + graphName + ", file=tempfile())").asRChar().getData()[0];
                }
            }
            catch (Exception exception) {}
        } else {
            analysis = "Graphs with variables are not yet supported for analysis.";
        }
        this.control.getDView().setAnalysis(analysis);
    }

    public boolean isTesting() {
        return this.testingStarted;
    }

    public GraphMCP loadGraph() {
        this.control.stopTesting();
        this.reset();
        boolean updateGUIOld = this.updateGUI;
        this.updateGUI = false;
        this.graph = new GraphMCP(this.initialGraph, this);
        this.control.getPView().restorePValues();
        if (this.graph.entangledWeights != null) {
            this.control.getPView().setEntangledWeights(this.graph.entangledWeights);
        }
        this.updateGUI = updateGUIOld;
        this.graphHasChanged();
        this.revalidate();
        this.repaint();
        if (this.graph.getDescription() != null) {
            this.control.getDView().setDescription(this.graph.getDescription());
        } else {
            this.control.getDView().setDescription("");
        }
        if (this.graph.test != null) {
            this.control.getPView().setTest(this.graph.test);
            if (this.graph.corMatName != null) {
                this.control.getPView().setCorrelation(this.graph.corMatName);
            }
        }
        return this.graph;
    }

    public void loadGraph(String string, boolean global) {
        if (global) {
            string = "get(\"" + string + "\", envir=globalenv())";
        }
        boolean matrix = RControl.getR().eval("is.matrix(" + string + ")").asRLogical().getData()[0];
        RControl.getR().eval(this.initialGraph + " <- placeNodes(" + (matrix ? "matrix2graph(" : "(") + string + "))");
        this.graph = this.loadGraph();
        if (this.graph.pvalues != null && this.graph.pvalues.length > 1) {
            this.control.getPView().setPValues(this.graph.pvalues);
        }
    }

    public void paintGraph(Graphics g) {
        this.nlp.get(0).paintComponent(g);
    }

    public void refresh() {
        this.calculateSize();
        this.revalidate();
        this.repaint();
    }

    public void removeEdge(Edge edge) {
        logger.info((Object)("Removing " + edge));
        for (Edge e : this.edges) {
            if (e.from != edge.to || e.to != edge.from || e.layer != edge.layer) continue;
            e.curve = false;
        }
        this.edges.remove(edge);
        this.getActiveNLP().dragE = new int[0];
        this.control.getDataFramePanel().setValueAt(new EdgeWeight(0.0), this.getNodes().indexOf(edge.from), this.getNodes().indexOf(edge.to), edge.layer);
        this.graphHasChanged();
    }

    public void removeEntangledLayer(int layer) {
        this.nlp.remove(layer + 1);
        this.remove(layer + 1);
        --this.layer;
        if (this.layer == 1) {
            this.setTitleAt(0, "Graph");
            this.remove(1);
            this.annotations.remove(this.entangledLegend);
            this.entangledLegend = null;
        } else {
            this.entangledLegend.rm(layer + 1, true);
            for (int j = 0; j < layer; ++j) {
                this.setTitleAt(j + 1, "Graph " + (j + 1));
            }
        }
        for (int i = this.edges.size(); i > 0; --i) {
            if (this.edges.get((int)(i - 1)).layer != layer) continue;
            this.edges.remove(i - 1);
        }
        for (Edge e : this.edges) {
            if (e.layer <= layer) continue;
            --e.layer;
            e.color = NetListPanel.layerColors[e.layer % NetListPanel.layerColors.length];
        }
        for (Node n : this.nodes) {
            n.removeLayer(layer);
        }
        for (int i = 1; i < this.nlp.size(); ++i) {
            this.nlp.get((int)i).layer = i - 1;
        }
        this.refresh();
    }

    public void removeNode(Node node) {
        logger.info((Object)("Removing " + node));
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            Edge e = this.edges.get(i);
            if (e.from != node && e.to != node) continue;
            this.edges.remove(e);
        }
        this.control.getDataFramePanel().delRowCol(this.getNodes().indexOf(node));
        this.nodes.remove(node);
        this.control.getPView().removePPanel(node);
        if (this.nodes.size() == 0) {
            this.control.enableButtons(false);
        }
        this.repaint();
        this.graphHasChanged();
    }

    public void reset() {
        logger.info((Object)"Reset.");
        this.edges.removeAllElements();
        for (int i = this.getNodes().size() - 1; i >= 0; --i) {
            this.removeNode(this.getNodes().get(i));
        }
        this.control.getDataFramePanel().reset();
        while (this.layer > 1) {
            this.removeEntangledLayer(this.layer - 1);
            this.control.getPView().removeEntangledLayer(this.layer - 1);
        }
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
        for (NetListPanel n : this.nlp) {
            n.reset();
        }
        this.zoom = 1.0;
        this.control.getDView().setDescription("Enter a description for the graph.");
        this.graphHasChanged();
        this.control.isGraphSaved = true;
    }

    public void saveGraph(boolean global) {
        this.saveGraph(this.initialGraph, false, global);
        this.control.getPView().savePValues();
    }

    public String saveGraph(String graphName, boolean verbose, boolean global, boolean addPValues, boolean addCorrelation) {
        String finalGraphName = this.saveGraph(graphName, verbose, new Hashtable<String, Double>(), global);
        if (addCorrelation) {
            String test = this.control.getPView().getTest();
            RControl.getR().evalVoid("attr(" + finalGraphName + ", \"test\") <- " + test, global);
            if (test.equals("\"parametric\"")) {
                String correlation = this.control.getPView().jcbCorObject.getSelectedItem().toString();
                RControl.getR().evalVoid("attr(" + finalGraphName + ", \"corMatName\") <- '" + correlation + "'", global);
                RControl.getR().evalVoid("attr(" + finalGraphName + ", \"corMat\") <- " + correlation, global);
            }
        }
        if (addPValues) {
            String pvals = this.control.getPView().getPValuesString();
            RControl.getR().evalVoid("attr(" + finalGraphName + ", \"pvalues\") <- " + pvals, global);
        }
        return finalGraphName;
    }

    public String saveGraph(String graphName, boolean verbose, boolean global) {
        return this.saveGraph(graphName, verbose, new Hashtable<String, Double>(), global);
    }

    public String saveGraph(String graphNameOld, boolean verbose, Hashtable<String, Double> ht, boolean global) {
        if (this.nodes.size() == 0) {
            throw new RuntimeException("Cannot save empty graph.");
        }
        String graphName = RControl.getR().eval("make.names(\"" + graphNameOld + "\")").asRChar().getData()[0];
        if (this.control.getNumberOfLayers() == 1) {
            this.saveSingleLayerGraph(graphName, verbose, ht, 0, global);
        } else {
            String graphs = "";
            String weights = "";
            for (int i = 0; i < this.control.getNumberOfLayers(); ++i) {
                this.saveSingleLayerGraph(this.tmpGraph + "_layer_" + i, verbose, ht, i, false);
                graphs = graphs + this.tmpGraph + "_layer_" + i;
                weights = weights + this.control.getPView().entangledWeights.get(i).getText();
                if (i == this.control.getNumberOfLayers() - 1) continue;
                graphs = graphs + ", ";
                weights = weights + ", ";
            }
            RControl.getR().evalVoid(graphName + " <- new(\"entangledMCP\", subgraphs=list(" + graphs + "), weights=c(" + weights + "))");
            if (global) {
                RControl.getR().evalVoidInGlobalEnv(graphName + " <- get(" + graphName + ", envir=gMCP:::gMCPenv)");
            }
        }
        RControl.getR().evalVoid("attr(" + graphName + ", \"description\") <- \"" + this.control.getDView().getDescription() + "\"", global);
        if (verbose && !graphName.equals(graphNameOld)) {
            JOptionPane.showMessageDialog(this, "The graph as been exported to R under ther variable name:\n\n" + graphName, "Saved as \"" + graphName + "\"", 1);
        }
        return graphName;
    }

    public String saveGraphWithoutVariables(String graphName, boolean verbose, boolean global) {
        Set<String> variables = this.getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        Hashtable<String, Double> ht = new Hashtable<String, Double>();
        if (!(variables.isEmpty() || variables.size() == 1 && variables.contains("\u03b5"))) {
            VariableDialog vd = new VariableDialog(this.control.parent, variables);
            ht = vd.getHT();
        } else if (variables.size() == 1 && variables.contains("\u03b5")) {
            ht.put("\u03b5", Configuration.getInstance().getGeneralConfig().getEpsilon());
        }
        graphName = RControl.getR().eval("make.names(\"" + graphName + "\")").asRChar().getData()[0];
        this.saveGraph(graphName, verbose, null, global);
        RControl.getR().eval(graphName + "<- gMCP:::replaceVariables(" + graphName + ", variables=" + this.getRVariableList(ht) + ", ask=FALSE)");
        this.loadGraph(graphName, false);
        return this.saveGraph(graphName, verbose, ht, global);
    }

    private void saveSingleLayerGraph(String graphName, boolean verbose, Hashtable<String, Double> ht, int layer, boolean global) {
        String alpha = "";
        String nodeStr = "";
        String x = "";
        String y = "";
        for (Node n : this.nodes) {
            alpha = alpha + n.getWeight().get(layer) + ",";
            nodeStr = nodeStr + "\"" + n.getRName() + "\",";
            x = x + n.getX() + ",";
            y = y + n.getY() + ",";
        }
        alpha = alpha.substring(0, alpha.length() - 1);
        nodeStr = nodeStr.substring(0, nodeStr.length() - 1);
        x = x.substring(0, x.length() - 1);
        y = y.substring(0, y.length() - 1);
        RControl.getR().evalVoid(".gsrmtVar <- list()");
        RControl.getR().evalVoid(".gsrmtVar$alpha <- c(" + alpha + ")");
        RControl.getR().evalVoid(".gsrmtVar$hnodes <- c(" + nodeStr + ")");
        RControl.getR().evalVoid(".gsrmtVar$m <- matrix(0, nrow=" + this.nodes.size() + ", ncol=" + this.nodes.size() + ")");
        RControl.getR().evalVoid("rownames(.gsrmtVar$m) <- colnames(.gsrmtVar$m) <- .gsrmtVar$hnodes");
        for (Edge e : this.edges) {
            if (e.layer != layer) continue;
            RControl.getR().evalVoid(".gsrmtVar$m[\"" + e.from.getRName() + "\",\"" + e.to.getRName() + "\"] <- \"" + e.getPreciseWeightStr().replaceAll("\\\\", "\\\\\\\\") + "\"");
        }
        RControl.getR().evalVoid(".gsrmtVar$m <- gMCP:::parse2numeric(.gsrmtVar$m)");
        RControl.getR().evalVoid(graphName + " <- new(\"graphMCP\", m=.gsrmtVar$m, weights=.gsrmtVar$alpha)");
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            Node n;
            n = this.nodes.get(i);
            if (!n.isRejected()) continue;
            RControl.getR().evalVoid("nodeAttr(" + graphName + ", \"" + n.getName() + "\", \"rejected\") <- TRUE");
        }
        RControl.getR().evalVoid(graphName + "@nodeAttr$X <- c(" + x + ")");
        RControl.getR().evalVoid(graphName + "@nodeAttr$Y <- c(" + y + ")");
        for (Edge e : this.edges) {
            if (e.layer != layer) continue;
            RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getRName() + "\", \"" + e.to.getRName() + "\", \"labelX\") <- " + (e.k1 - Node.getRadius()));
            RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getRName() + "\", \"" + e.to.getRName() + "\", \"labelY\") <- " + (e.k2 - Node.getRadius()));
            if (Double.valueOf(e.getW(ht)).isNaN()) {
                RControl.getR().evalVoid("edgeAttr(" + graphName + ", \"" + e.from.getRName() + "\", \"" + e.to.getRName() + "\", \"variableWeight\") <- \"" + e.getWS().replaceAll("\\\\", "\\\\\\\\") + "\"");
            }
            if (e.getW(ht) != 0.0) continue;
            RControl.getR().evalVoid(graphName + "@m[\"" + e.from.getRName() + "\", \"" + e.to.getRName() + "\"] <- 0");
        }
        if (global) {
            RControl.getR().evalVoidInGlobalEnv(graphName + " <- get(\"" + graphName + "\", env=gMCP:::gMCPenv)");
        }
    }

    public void setEdge(Edge e) {
        Edge old = null;
        for (Edge e2 : this.edges) {
            if (e2.from == e.from && e2.to == e.to && e2.layer == e.layer) {
                old = e2;
            }
            if (e2.from != e.to || e2.to != e.from || e2.layer != e.layer) continue;
            e.curve = true;
            e2.curve = true;
        }
        if (old != null) {
            this.edges.remove(old);
        }
        this.edges.add(e);
        this.control.getDataFramePanel().setValueAt(e.getEdgeWeight(), this.getNodes().indexOf(e.from), this.getNodes().indexOf(e.to), e.layer);
        this.graphHasChanged();
    }

    public void setEdge(Node from, Node to, Double w, int layer) {
        this.setEdge(from, to, new EdgeWeight(w), layer);
    }

    public void setEdge(Node from, Node to, EdgeWeight w, int layer) {
        Integer x = null;
        Integer y = null;
        boolean curve = false;
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            if (this.edges.get((int)i).from != from || this.edges.get((int)i).to != to || this.edges.get((int)i).layer != layer) continue;
            x = this.edges.get(i).getK1();
            y = this.edges.get(i).getK2();
            this.removeEdge(this.edges.get(i));
        }
        for (Edge e : this.edges) {
            if (e.from != to || e.to != from || e.layer != layer) continue;
            e.curve = true;
            curve = true;
        }
        if (!w.toString().equals("0")) {
            if (x != null) {
                this.edges.add(new Edge(from, to, w, this, (int)x, (int)y, layer));
            } else {
                this.edges.add(new Edge(from, to, w, this, curve, layer));
            }
            this.edges.lastElement().curve = curve;
        }
        this.control.getDataFramePanel().setValueAt(w, this.getNodes().indexOf(from), this.getNodes().indexOf(to), layer);
        this.graphHasChanged();
    }

    public void setEdge(Node from, Node to, int layer) {
        this.setEdge(from, to, 1.0, layer);
    }

    public void setEdge(Node firstVertex, Node secondVertex, NetListPanel netListPanel) {
        this.setEdge(firstVertex, secondVertex, this.askForLayer());
    }

    public void setEdges(Vector<Edge> edges) {
        this.edges = edges;
        this.graphHasChanged();
    }

    public void setNodes(Vector<Node> nodes) {
        this.nodes = nodes;
        this.graphHasChanged();
    }

    public void setNewEdge(boolean b) {
        for (NetListPanel n : this.nlp) {
            n.newEdge = b;
            if (b) continue;
            n.arrowHeadPoint = null;
            n.firstVertexSelected = false;
        }
    }

    public void edgeWasSet() {
        for (NetListPanel n : this.nlp) {
            n.newEdge = false;
            n.arrowHeadPoint = null;
            n.firstVertexSelected = false;
        }
    }

    public void setNewVertex(boolean b) {
        for (NetListPanel n : this.nlp) {
            n.newVertex = b;
        }
    }

    public void setZoom(double p) {
        this.zoom = p;
    }

    public void startTesting() {
        this.testingStarted = true;
        this.statusBar.setText("Reject nodes or reset to the initial graph for modifications.");
    }

    public void stopTesting() {
        this.testingStarted = false;
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
    }

    public int whichNode(String name) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int i = this.getSelectedIndex();
        if (i != 0) {
            this.control.getDataFramePanel().setSelectedIndex(i - 1);
        }
    }

    public Edge getEdge(int i, int j, int layer) {
        if (i < 0 || j < 0 || i >= this.nodes.size() || j >= this.nodes.size()) {
            return null;
        }
        for (Edge e : this.getEdges()) {
            if (e.from != this.nodes.get(i) || e.to != this.nodes.get(j) || e.layer != layer) continue;
            return e;
        }
        return null;
    }

    public void highlightEdge(int i, int j, int layer) {
        Edge e = this.getEdge(this.oldi, this.oldj, layer);
        if (e != null) {
            e.linewidth = this.oldLinewidth;
        }
        if ((e = this.getEdge(i, j, layer)) == null) {
            this.oldi = -1;
            this.oldj = -1;
            return;
        }
        this.oldi = i;
        this.oldj = j;
        this.oldLinewidth = e.linewidth;
        e.linewidth = 3;
        this.repaint();
    }

    public void setEntangledLegendWeight(int i, String weight) {
        if (this.entangledLegend == null) {
            return;
        }
        try {
            this.entangledLegend.setText(i + 1, "Component Graph " + (i + 1) + ": " + weight);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.repaint();
    }

    public int getLayer() {
        return this.layer;
    }

    public void setRadius(int r) {
        Node.setRadius(r);
        for (Node n : this.nodes) {
            n.reCenter();
        }
    }
}

