/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetListSelectionPopUpMenu
extends JPopupMenu
implements ActionListener {
    JMenuItem anItem;
    NetList nl;
    List<Node> nodes;
    List<Edge> edges;

    public NetListSelectionPopUpMenu(NetList nl, List<Node> nodes, List<Edge> edges) {
        this.nl = nl;
        this.nodes = nodes;
        this.edges = edges;
        this.add(this.makeMenuItem("Move", "move", !nl.isTesting()));
        this.add(this.makeMenuItem("Create subfamily", "subfamily", !nl.isTesting()));
    }

    protected JMenuItem makeMenuItem(String text, String action) {
        return this.makeMenuItem(text, action, true);
    }

    protected JMenuItem makeMenuItem(String text, String action, boolean enabled) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.setEnabled(enabled);
        item.addActionListener(this);
        return item;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("move")) {
            int i;
            this.nl.dragN = new int[this.nodes.size()];
            this.nl.dragE = new int[this.edges.size()];
            for (i = 0; i < this.nodes.size(); ++i) {
                this.nl.dragN[i] = this.nl.getNodes().indexOf(this.nodes.get(i));
            }
            for (i = 0; i < this.edges.size(); ++i) {
                this.nl.dragE[i] = this.nl.getEdges().indexOf(this.edges.get(i));
            }
        } else if (e.getActionCommand().equals("subfamily")) {
            // empty if block
        }
        this.nl.repaint();
    }
}

