% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plotSimCI}
\alias{plotSimCI}
\title{Plot confidence intervals}
\usage{
plotSimCI(ci)
}
\arguments{
\item{ci}{a (named) matrix containing the lower confidence bounds in the
first column, the point estimates in the second and the upper confidence
bounds in the third column.}
}
\description{
A function for convenient plotting of confidence intervals.
}
\examples{
est <- c("H1"=0.860382, "H2"=0.9161474, "H3"=0.9732953)
# Sample standard deviations:
ssd <- c("H1"=0.8759528, "H2"=1.291310, "H3"=0.8570892)

pval <- c(0.01260, 0.05154, 0.02124)/2

ci <- simConfint(BonferroniHolm(3), pvalues=pval,
  	confint="t", df=9, estimates=est, alpha=0.025, alternative="greater")

plotSimCI(ci)
}
\author{
Code adapted from plotCII from Frank Schaarschmidt
}
\keyword{hplot}

