/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.DesktopPaneBG;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.MenuBarMGraph;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.options.GeneralPanel;
import org.af.gMCP.gui.options.MiscPanel;
import org.af.gMCP.gui.options.NumericPanel;
import org.af.gMCP.gui.options.SetLookAndFeelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionsDialog
extends JDialog
implements ActionListener {
    private static final Log logger = LogFactory.getLog(OptionsDialog.class);
    private JTabbedPane tabbedPane;
    private GeneralPanel visualPanel;
    private NumericPanel numericPanel;
    private MiscPanel miscPanel;
    private JPanel bp;
    private Configuration conf;
    CreateGraphGUI parent;
    JButton jbHelp;
    static final String HELP = "HELP";

    public OptionsDialog(CreateGraphGUI p) {
        super(p);
        this.parent = p;
        this.conf = Configuration.getInstance();
        this.setModal(true);
        this.setTitle("Options");
        this.setDefaultCloseOperation(2);
        this.makeComponents();
        this.doTheLayout();
        this.pack();
        this.setLocationRelativeTo(p);
        this.setVisible(true);
    }

    private void makeComponents() {
        this.tabbedPane = new JTabbedPane();
        this.visualPanel = new GeneralPanel(this.parent, this);
        this.numericPanel = new NumericPanel(this.conf);
        this.miscPanel = new MiscPanel(this.conf);
        this.bp = this.getButtonPane();
    }

    private JPanel getButtonPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        try {
            this.jbHelp = new JButton("Help", new ImageIcon(ImageIO.read(DesktopPaneBG.class.getResource("/org/af/gMCP/gui/graph/images/questionmark.png"))));
        }
        catch (IOException e) {
            ErrorHandler.getInstance().makeErrDialog(e.getMessage(), (Object)e);
            this.jbHelp = new JButton("Help!");
        }
        this.jbHelp.addActionListener(this);
        this.jbHelp.setActionCommand(HELP);
        panel.add(this.jbHelp);
        panel.add(Box.createHorizontalStrut(5));
        JButton cancel = new JButton(Localizer.getInstance().getString("AFCOMMONS_WIDGETS_BUTTONS_CANCEL"));
        cancel.setActionCommand("CANCEL");
        panel.add(cancel);
        cancel.addActionListener(this);
        panel.add(Box.createHorizontalStrut(5));
        JButton apply = new JButton(Localizer.getInstance().getString("AFCOMMONS_WIDGETS_BUTTONS_APPLY"));
        apply.addActionListener(this);
        apply.setActionCommand("APPLY");
        panel.add(apply);
        panel.add(Box.createHorizontalStrut(5));
        JButton ok = new JButton(Localizer.getInstance().getString("AFCOMMONS_WIDGETS_BUTTONS_OK"));
        ok.setActionCommand("OK");
        ok.addActionListener(this);
        panel.add(ok);
        panel.add(Box.createHorizontalStrut(5));
        return panel;
    }

    public static JPanel makeDialogPanelWithButtons(Container content, JPanel hbp) {
        JPanel p = new JPanel();
        String cols = "fill:pref:grow";
        String rows = "fill:pref:grow, 5dlu, bottom:pref:n";
        FormLayout layout = new FormLayout(cols, rows);
        p.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        p.add((Component)content, cc.xy(1, 1));
        p.add((Component)hbp, cc.xy(1, 3, "right, bottom"));
        p.setBorder(new EmptyBorder(5, 5, 5, 5));
        return p;
    }

    private void doTheLayout() {
        this.tabbedPane.addTab("Visual", this.visualPanel);
        this.tabbedPane.addTab("Numeric", this.numericPanel);
        this.tabbedPane.addTab("Misc", this.miscPanel);
        Container cp = this.getContentPane();
        cp.add(this.tabbedPane);
        cp = OptionsDialog.makeDialogPanelWithButtons(cp, this.bp);
        this.setContentPane(cp);
    }

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("Got ActionCommand " + e.getActionCommand()));
        if (e.getActionCommand().equals("OK") || e.getActionCommand().equals("APPLY")) {
            try {
                this.visualPanel.setProperties();
                this.numericPanel.setProperties();
                this.miscPanel.setProperties();
                if (e.getActionCommand().equals("OK")) {
                    this.dispose();
                }
                for (Edge edge : this.parent.getGraphView().getNL().getEdges()) {
                }
                for (Node node : this.parent.getGraphView().getNL().getNodes()) {
                    node.createWeightIcons();
                }
                this.parent.repaint();
            }
            catch (ValidationException exc) {
                JOptionPane.showMessageDialog(this, exc.getMessage());
            }
            catch (SetLookAndFeelException exc) {
                ErrorHandler.getInstance().makeErrDialog(exc.getMessage(), (Object)exc);
            }
        }
        if (e.getActionCommand().equals("CANCEL")) {
            this.dispose();
        }
        if (e.getActionCommand().equals(HELP)) {
            this.parent.openHelp("options");
        }
        ((MenuBarMGraph)this.parent.getJMenuBar()).createExampleMenu();
        ((MenuBarMGraph)this.parent.getJMenuBar()).createExtraMenu();
    }
}

