% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_arDist.R
\name{array-distribution}
\alias{ardist}
\alias{array-distribution}
\alias{tabDist}
\title{Marginalize and condition in multidimensional array.}
\usage{
ardist(tab, marg = NULL, cond = NULL, normalize = TRUE)
}
\arguments{
\item{tab}{Multidimensional array with dimnames.}

\item{marg}{A specification of the desired margin; a character vector, a
numeric vector or a right hand sided formula.}

\item{cond}{A specification of what is conditioned on. Can take two forms:
Form one is a a character vector, a numeric vector or a right hand sided
formula. Form two is as a simple slice of the array, which is a list of
the form var1=value1, var2=value2 etc.}

\item{normalize}{Should the result be normalized to sum to 1.}
}
\value{
A multidimensional array.
}
\description{
Marginalize and condition in a multidimensional array which is
    assumed to represent a discrete multivariate distribution.
}
\note{
\code{ardist} is a recent addition and its functionality (and name) may
    change. \code{ardist} is based on calling \code{arMarg} and
    \code{arSlice}.
}
\examples{

hec <- HairEyeColor

is.named.array( hec )
## We need dimnames, and names on the dimnames

## Marginalize:
ardist(hec, marg= ~Hair + Eye)
ardist(hec, marg= ~Hair:Eye)
ardist(hec, marg= c("Hair", "Eye"))
ardist(hec, marg= 1:2)

ardist(hec, marg= ~Hair + Eye, normalize=FALSE)

## Condition
ardist(hec, cond= ~Sex + Hair)
ardist(hec, cond= ~Sex:Hair)
ardist(hec, cond= c("Sex", "Hair"))
ardist(hec, cond= c(3,1))

ardist(hec, cond= list(Hair="Black"))
ardist(hec, cond= list(Hair=1))

\dontrun{
## This will fail
ardist(hec, cond= list(Hair=c("Black", "Brown")))
ardist(hec, cond= list(Hair=1:2))
}
## But this will do the trick
a <- arslice(hec, slice=list(Hair=c("Black", "Brown")))
ardist(a, cond=~Hair)

## Combined
ardist(hec, marg=~Hair+Eye, cond=~Sex)
ardist(hec, marg=~Hair+Eye, cond="Sex")

ardist(hec, marg=~Hair+Eye, cond=list(Sex="Male"))
ardist(hec, marg=~Hair+Eye, cond=list(Sex="Male"), normalize=FALSE)

ardist(hec, cond=list(Sex="Male"))
ardist(hec, cond=list(Sex="Male"), normalize=FALSE)

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\seealso{
\code{\link{newar}}, \code{\link{armarg}}, \code{\link{arslice}} etc.
}
\keyword{utilities}

