% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-main.R, R/fit-rcox-scoring.R
\name{fit-main}
\alias{fit-main}
\alias{fit.rcox}
\alias{matching}
\alias{ipm}
\alias{scoring}
\title{Fit rcox model}
\usage{
\method{fit}{rcox}(
  object,
  Kstart = object$Kstart,
  method = object$method,
  control = object$control,
  details = object$details,
  trace = object$trace,
  returnModel = TRUE,
  ...
)

matching(object, control = object$control, trace = object$trace)

ipm(object, K0, control = object$control, trace = object$trace)

scoring(
  object,
  K0,
  control = object$control,
  maxit = control$maxouter,
  trace = object$trace
)
}
\arguments{
\item{object}{An RCOX model object (an object of class 'rcox')}

\item{Kstart}{An initial value for the concentration matrix.}

\item{method}{The specific estimation method. Can be either
"scoring", (a modified Fisher scoring algorithm), "ipm"
(iterative partial maximization), "matching" (score matching) or
"user" (currently not used).}

\item{control}{A list controlling the fitting algorithms. See the
'details' section.}

\item{details}{The amount of details printed on the screen. 0 means
no details at all.}

\item{trace}{Controls various diagnostics print outs. A debugging
feature not intended for the user.}

\item{returnModel}{If TRUE the model object m is returned with
fitting info added to it. If FALSE only the fitting info is
returned.}

\item{...}{Additional arguments; currently not used.}

\item{K0}{Initial value for concentration matrix.}

\item{maxit}{Maximum number of iterations.}
}
\value{
An RCOX model object.
}
\description{
This is a general function for fitting RCOX models
(i.e.\ RCON and RCOR models) using different estimation
algorithms.
}
\details{
The fitted parameters etc. can be extracted using
'fitInfo(m)'.  The control argument is a list with named
entries. Most important are the entries 'maxouter' and 'maxinner'
(which both defaults to 25) for controlling the estimation
algorithms. For other components please  refer to the code.
}
\examples{

data(math)
gm  = ~al:an:st
vcc = list(~me + st, ~ve + an, ~al)
ecc = list(~me:ve + me:al, ~ve:al + al:st)

m1 <- rcox(gm=gm, vcc=vcc, ecc=ecc, data=math, fit=FALSE)

fit(m1, method="matching")
fit(m1, method="scoring")
fit(m1, method="ipm")

}
\seealso{
\code{\link{rcox}}, \code{\link{update.rcox}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
