% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_call.R, R/print.R
\name{galah_call}
\alias{galah_call}
\alias{print.data_request}
\title{Start building a data query}
\usage{
galah_call(
  identify = NULL,
  filter = NULL,
  select = NULL,
  geolocate = NULL,
  data_profile = NULL,
  group_by = NULL,
  down_to = NULL,
  ...
)

\method{print}{data_request}(x, ...)
}
\arguments{
\item{identify}{\code{data.frame}: generated by a call to \code{\link[=galah_identify]{galah_identify()}}}

\item{filter}{\code{data.frame}: generated by a call to \code{\link[=select_filters]{select_filters()}}}

\item{select}{\code{data.frame}: generated by a call to \code{\link[=galah_select]{galah_select()}}}

\item{geolocate}{\code{string}: generated by a call to \code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to \code{\link[=galah_apply_profile]{galah_apply_profile()}}}

\item{group_by}{\code{data.frame}: generated by a call to \code{\link[=galah_group_by]{galah_group_by()}}}

\item{down_to}{\code{data.frame}: generated by a call to \code{\link[=galah_down_to]{galah_down_to()}}}

\item{...}{other function-specific request parameters}

\item{x}{an object of class \code{data_request}}
}
\value{
An object of class \code{data_request}.
}
\description{
To download data from the ALA (or another atlas), one must construct a data
query. This query tells the atlas API what data to download and return, as
well as how it should be filtered.
}
\details{
The \code{galah} package enables users to
construct their data queries using piping syntax (i.e., \verb{\%>\%} from \code{magrittr},
or \verb{|>} from \code{base}).

Start a query with \code{galah_call()}. Pipe functions like \code{\link[=galah_identify]{galah_identify()}},
\code{\link[=galah_filter]{galah_filter()}}, \verb{[galah_select()]}, and \code{\link[=galah_group_by]{galah_group_by()}} to narrow your
query and specify filters. Finish a query with an \code{atlas_} function to
identify which type of data is downloaded (i.e., \code{\link[=atlas_occurrences]{atlas_occurrences()}},
\code{\link[=atlas_counts]{atlas_counts()}}, \code{\link[=atlas_species]{atlas_species()}}, \code{\link[=atlas_taxonomy]{atlas_taxonomy()}} or \code{\link[=atlas_media]{atlas_media()}}).

Using \code{galah_call()} with pipes allows you to build & filter
a query to download data in the same way that you would wrangle data
with \code{dplyr} and the \code{tidyverse}.
}
\examples{
# Begin your query with `galah_call()`, then pipe using `\%>\%` or `|>`

# Get number of records of *Aves* from 2001 to 2004 by year
galah_call() |>
  galah_identify("Aves") |>
  galah_filter(year > 2000 & year < 2005) |>
  galah_group_by() |>
  atlas_counts()
  
# Get information for all species in *Cacatuidae* family
galah_call() |>
  galah_identify("Cacatuidae") |>
  atlas_species()
\dontrun{ 
# Download records of genus *Eolophus* from 2001 to 2004
galah_config(email = "your-email@email.com")

galah_call() |>
  galah_identify("Eolophus") |>
  galah_filter(year > 2000 & year < 2005) |>
  atlas_occurrences()
}
}
