% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_taxonomy.R
\name{atlas_taxonomy}
\alias{atlas_taxonomy}
\title{Search taxonomic trees}
\usage{
atlas_taxonomy(
  request = NULL,
  identify = NULL,
  filter = NULL,
  constrain_ids = NULL
)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{galah_filter(rank == "chosen_rank")}. The
identity of the clade at which the downwards search should stop.}

\item{constrain_ids}{\code{string}: Optional string to limit which \code{taxon_concept_id}'s
are returned. This is useful for restricting taxonomy to particular
authoritative sources. Default is \code{"biodiversity.org.au"} for Australia
(this can be overridded by setting \code{constrain_ids = NULL}) and NULL otherwise.
Powered by \code{grepl()} meaning it supports regular expressions.}
}
\value{
A \code{tibble} containing taxon names, ranks and parent/child IDs
}
\description{
The ALA has its' own internal taxonomy that is derived from authoritative
sources. \code{atlas_taxonomy} provides a means to query
that taxonomy, returning a \code{tibble} showing all child nodes and which parent
they are derived from.
}
\details{
The approach used by this function is recursive, meaning that it
becomes slow for large queries such as
\code{atlas_taxonomy(search_taxa("Plantae"), down_to = galah_down_to(species))}.
Although the inputs to \code{search_taxa} and \code{down_to} are
case-insensitive, node names are always returned in title case.
}
\examples{
\dontrun{
# Get a taxonomic tree of *Chordata* down to the class level
galah_call() |> 
  galah_identify("chordata") |>
  galah_filter(rank == class) |>
  atlas_taxonomy()
}

}
\seealso{
\code{\link[=search_taxa]{search_taxa()}} to search for an individual taxon;
\code{show_all(ranks)} for valid ranks used to specify the \code{down_to}
argument.
}
\keyword{internal}
