% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_loadings.R
\name{factor_loadings.galamm}
\alias{factor_loadings.galamm}
\alias{factor_loadings}
\title{Extract factor loadings from galamm object}
\usage{
\method{factor_loadings}{galamm}(object)
}
\arguments{
\item{object}{Object of class \code{galamm} returned from
\code{\link{galamm}}.}
}
\value{
A matrix containing the estimated factor loadings with corresponding
standard deviations.
}
\description{
Extract factor loadings from galamm object
}
\details{
This function has been named \code{factor_loadings} rather than just
\code{loadings} to avoid conflict with \code{stats::loadings}.
}
\examples{
# Logistic mixed model with factor loadings, example from PLmixed
data("IRTsim", package = "PLmixed")

# Reduce data size for the example to run faster
IRTsub <- IRTsim[IRTsim$item < 4, ]
IRTsub <- IRTsub[sample(nrow(IRTsub), 300), ]
IRTsub$item <- factor(IRTsub$item)

# Fix loading for first item to 1, and estimate the two others freely
loading_matrix <- matrix(c(1, NA, NA), ncol = 1)

# Estimate model
mod <- galamm(y ~ item + (0 + ability | sid) + (0 + ability | school),
  data = IRTsub, family = binomial, load_var = "item",
  factor = "ability", lambda = loading_matrix
)

# Show estimated factor loadings, with standard errors
factor_loadings(mod)

}
\seealso{
\code{\link[=fixef.galamm]{fixef.galamm()}} for fixed regression coefficients,
\code{\link[=confint.galamm]{confint.galamm()}} for confidence intervals, and \code{\link[=coef.galamm]{coef.galamm()}} for
coefficients more generally.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\author{
The example for this function comes from \code{PLmixed}, with authors
Nicholas Rockwood and Minjeong Jeon
\insertCite{rockwoodEstimatingComplexMeasurement2019}{galamm}.
}
\concept{details of model fit}
