% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_archive.R, R/get_report.R,
%   R/view_report.R, R/print_gbif_validator.R
\name{check_archive}
\alias{check_archive}
\alias{get_report}
\alias{view_report}
\alias{print.gbif_validator}
\title{Check whether an archive meets the Darwin Core Standard via API}
\usage{
check_archive(
  file = "dwc-archive.zip",
  username = NULL,
  email = NULL,
  password = NULL,
  wait = TRUE,
  quiet = FALSE
)

get_report(
  obj,
  username = NULL,
  password = NULL,
  n = 5,
  wait = TRUE,
  quiet = FALSE
)

view_report(x, n = 5)

\method{print}{gbif_validator}(x, ...)
}
\arguments{
\item{file}{The name of the file in the parent directory to pass to the
validator API, ideally created using \code{\link[=build_archive]{build_archive()}}.}

\item{username}{Your GBIF username.}

\item{email}{The email address used to register with \code{gbif.org}.}

\item{password}{Your GBIF password.}

\item{wait}{(logical) Whether to wait for a completed report from the API
before exiting (\code{TRUE}, the default), or try the API once and return the
result regardless (\code{FALSE}).}

\item{quiet}{(logical) Whether to suppress messages about what is happening.
Default is set to \code{FALSE}; i.e. messages are shown.}

\item{obj}{Either an object of class \code{character} containing a key that
uniquely identifies your query; or an object of class \code{gbif_validator}.
returned by \code{\link[=check_archive]{check_archive()}} or \code{\link[=get_report]{get_report()}}}

\item{n}{Maximum number of entries to print per file. Defaults to 5.}

\item{x}{An object of class \code{gbif_validator}.}

\item{\dots}{Additional arguments, currently ignored.}
}
\value{
Both \code{check_archive()} and \code{get_report()} return an object of class
\code{gbif_validator} to the workspace. \code{view_report()} and
\code{print.gbif_validator()} don't return anything, and are called for the
side-effect of printing useful information to the console.
}
\description{
Check whether a specified Darwin Core Archive is ready for
sharing and publication, according to the Darwin Core Standard.
\code{check_archive()} tests an archive - defaulting to \code{"dwc-archive.zip"} in
the users' parent directory - using an online validation service. Currently
only supports validation using GBIF.
}
\details{
Internally, \code{check_archive()} both \code{POST}s the specified archive to the GBIF
validator API and then calls \code{get_report()} to retrieve (\code{GET}) the result.
\code{\link[=get_report]{get_report()}} is exported to allow the user to download results at a later
time should they wish; this is more efficient than repeatedly generating
queries with \code{check_archive()} if the underlying data are unchanged. A third
option is simply to assign the outcome of \code{check_archive()} or \code{get_report()}
to an object, then call \code{view_report()} to format the result nicely. This
approach doesn't require any further API calls and is considerably faster.

Note that information returned by these functions is provided verbatim from
the institution API, not from galaxias.
}
\seealso{
\code{\link[=check_directory]{check_directory()}} which runs checks on a directory (but \strong{not}
an archive) locally, rather than via API.
}
