% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldaErr.R
\name{ldaErr}
\alias{ldaErr}
\title{Calculate Error Rates for Linear Discriminant Model}
\usage{
ldaErr(train.lda, train, test, group = "type")
}
\arguments{
\item{train.lda}{Fitted lda model object.}

\item{train}{Training set data frame.}

\item{test}{Test set data frame.}

\item{group}{Factor that identifies groups in training data.}
}
\value{
Vector that holds leave-one-out, training, and test error
rates
}
\description{
Given an lda model object, calculate training set error,
leave-one-out cross-validation error, and test set error.
}
\examples{
\dontrun{
data(spam, package='kernlab')
spam[,-58] <- scale(spam[,-58])
nr <- sample(1:nrow(spam))
spam01 <- spam[nr[1:3601],]     ## Use for training,
spam2 <- spam[nr[3602:4601],]   ## Test
spam01.lda <- lda(type~., data=spam01)
ldaRates <- ldaErr(train.lda=spam01.lda, train=spam01, test=spam2, group="type")
}

}
