% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot-method}
\alias{plot,GammaSpectrum,missing-method}
\alias{plot,GammaSpectrum,Baseline-method}
\alias{plot,GammaSpectra,missing-method}
\alias{plot,GammaSpectrum,PeakPosition-method}
\alias{plot,CalibrationCurve,missing-method}
\title{Plot}
\usage{
\S4method{plot}{GammaSpectrum,missing}(x, xaxis = c("channel", "energy"), yaxis = c("count", "rate"), ...)

\S4method{plot}{GammaSpectrum,Baseline}(x, y, xaxis = c("channel", "energy"), yaxis = c("count", "rate"), ...)

\S4method{plot}{GammaSpectra,missing}(
  x,
  xaxis = c("channel", "energy"),
  yaxis = c("count", "rate"),
  select = NULL,
  facet = FALSE,
  nrow = c("fixed", "auto")
)

\S4method{plot}{GammaSpectrum,PeakPosition}(x, y, split = FALSE, span = 25)

\S4method{plot}{CalibrationCurve,missing}(
  x,
  error_ellipse = TRUE,
  error_bar = FALSE,
  energy = FALSE,
  level = 0.95,
  n = 50,
  ...
)
}
\arguments{
\item{x, y}{Objects to be plotted.}

\item{xaxis, yaxis}{A \code{\link{character}} string specifying the data to be plotted
along each axis. It must be one of "\code{energy}" or "\code{channel}" (\code{x} axis) and
"\code{counts}" or "\code{rate}" (\code{y} axis). Any unambiguous substring can be given.}

\item{...}{Currently not used.}

\item{select}{A \code{\link{numeric}} or \code{\link{character}} vector giving the selection of
the spectrum that are drawn.}

\item{facet}{A \code{\link{logical}} scalar: should a matrix of panels defined by
spectrum be drawn?}

\item{nrow}{A \code{\link{character}} string specifying the number of rows.
It must be one of "\code{fixed}" or "\code{auto}". Any unambiguous substring can be
given. Only used if \code{facet} is \code{TRUE}.}

\item{split}{A \code{\link{logical}} scalar: should.}

\item{span}{An \code{\link{integer}} giving the half window size (in number of
channels). Only used if \code{split} is \code{TRUE}.}

\item{error_ellipse}{A \code{\link{logical}} scalar: should error ellipses be plotted?}

\item{error_bar}{A \code{\link{logical}} scalar: should error bars be plotted?}

\item{energy}{A \code{\link{logical}} scalar: TODO.}

\item{level}{length-one \code{\link{numeric}} vector giving the the probability cutoff
for the error ellipses.}

\item{n}{A length-one \code{\link{numeric}} vector giving the resolution of the error
ellipses.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plot
}
\examples{
# Import CNF files
spc_dir <- system.file("extdata/BDX_LaBr_1/calibration", package = "gamma")
spc <- read(spc_dir)

# Plot all spectra
plot(spc, yaxis = "rate", facet = FALSE) +
  ggplot2::theme_bw()

# Plot the spectrum named 'BRIQUE'
plot(spc, xaxis = "energy", yaxis = "count", select = "BRIQUE") +
  ggplot2::theme_bw()

# Plot the first three spectra
plot(spc, xaxis = "channel", yaxis = "rate", select = 1:3, facet = TRUE) +
  ggplot2::theme_bw()
}
\seealso{
\code{\link[IsoplotR:ellipse]{IsoplotR::ellipse()}}, \code{\link[IsoplotR:isochron]{IsoplotR::isochron()}}
}
\author{
N. Frerebeau
}
\concept{plot}
