% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdTrain.R
\name{gdTrainParameters}
\alias{gdTrainParameters}
\title{Specify parameters for training of generative model}
\usage{
gdTrainParameters(
  numberOfIterations = 10000,
  numberOfHiddenLayerUnits = 1024,
  learningRate = 7e-05,
  dropout = 0.05
)
}
\arguments{
\item{numberOfIterations}{Number of training iterations}

\item{numberOfHiddenLayerUnits}{Number of hidden layer units}

\item{learningRate}{Learning rate for training of neural networks}

\item{dropout}{Value in the range of 0 to 1. Specifies the rate of hidden
units that are dropped. Dropout is a regularization method to prevent
overfitting.}
}
\value{
List of parameters for training of generative model
}
\description{
Specify parameters for training of neural networks used for generation of
generative data. These parameters are passed to function gdTrain().
}
\examples{
\dontrun{
generateParameters <- gdGenerateParameters(numberOfIterations = 5000)}
}
