% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expr-generics.R, R/Expr-methods.R,
%   R/Segment-methods.R
\docType{methods}
\name{ScopeLevel}
\alias{ScopeLevel}
\alias{ScopeLevel<-}
\alias{ScopeLevel,gaSegMetExpr,missing-method}
\alias{ScopeLevel,gaSegMetExpr,character-method}
\alias{ScopeLevel<-,gaMetExpr,character-method}
\alias{ScopeLevel,.gaSegmentFilter,ANY-method}
\alias{ScopeLevel<-,.gaSegmentFilter,character-method}
\alias{ScopeLevel<-,gaDynSegment,character-method}
\title{ScopeLevel.}
\usage{
ScopeLevel(object, value)

ScopeLevel(object) <- value

\S4method{ScopeLevel}{gaSegMetExpr,missing}(object)

\S4method{ScopeLevel}{gaSegMetExpr,character}(object, value)

\S4method{ScopeLevel}{gaMetExpr,character}(object) <- value

\S4method{ScopeLevel}{.gaSegmentFilter,ANY}(object)

\S4method{ScopeLevel}{.gaSegmentFilter,character}(object) <- value

\S4method{ScopeLevel}{gaDynSegment,character}(object) <- value
}
\arguments{
\item{object}{a .gaSegmentFilter or a metric expression.}

\item{value}{New scope level to return an updated copy of the object
with the new scope applied. For .gaSegmentFilters this can be
either 'users' or 'sessions'. For metric expressions use either 'perUser',
'perSession', 'perHit' or 'perProduct'.}
}
\value{
the scope level as a character string, a .gaSegmentFilter or gaMetExpr.
}
\description{
Get the scope level of a .gaSegmentFilter or gaMetExpr.

Set the scope level of a gaDynSegment or a gaMetExpr
}
\section{Methods (by class)}{
\itemize{
\item \code{object = gaSegMetExpr,value = missing}: Return the scope of the supplied metric used within a
segment definition.

\item \code{object = gaSegMetExpr,value = character}: Set the scope, as described by a character value, to
be applied to the supplied metric condition for use within a segment
expression.

\item \code{object = gaMetExpr,value = character}: Set the scope, as described by a character value, to
be applied to the supplied metric condition for use within a segment
expression.

\item \code{object = .gaSegmentFilter,value = ANY}: Returns the scope of the supplied .gaSegmentFilter.

\item \code{object = .gaSegmentFilter,value = character}: Set the scope level of a .gaSegmentFilter to either
"user" or "session" level.

\item \code{object = gaDynSegment,value = character}: Set the scope level of a gaDynSegment to either
"user" or "session" level.
}}

