% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expr-generics.R, R/Expr-methods.R
\docType{methods}
\name{Expr}
\alias{Expr}
\alias{Expr,.expr,ANY-method}
\alias{Expr,formula,ANY-method}
\alias{Expr,character,character-method}
\title{Expr}
\usage{
Expr(object, comparator, operand, metricScope = "")

\S4method{Expr}{.expr,ANY}(object)

\S4method{Expr}{formula,ANY}(object, metricScope)

\S4method{Expr}{character,character}(object, comparator, operand,
  metricScope = "")
}
\arguments{
\item{object}{A dimension or metric variable, or another object to be coerced
to an \code{.expr} object.}

\item{comparator}{The comparator to use for the expression.}

\item{operand}{The operand to use for the expression.}

\item{metricScope}{Optional scope to use in the case of metric variables for
segmentation. Possible values include \code{"perUser"} or
\code{"perSession"}.}
}
\description{
Define a Google Analytics expression.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = .expr,comparator = ANY}: Returns itself.

\item \code{object = formula,comparator = ANY}: Use non-standard formula evaluation to define an expression.
Accepts a formula in the form of: \code{~ <variable> <comparator>
  <operand>} where only the \code{<operand>} is evaluated.

\item \code{object = character,comparator = character}: Return an expression composed of the supplied variable,
comparator and operand arguments.
}}

\examples{
source_google <- Expr(~source == "google")
source_google <- Expr("source", "==", "google")
bounces <- Expr("bounces", ">", 0)
}
\seealso{
Other expression generators: \code{\link{GaExpr}},
  \code{\link{McfExpr}}, \code{\link{RtExpr}}
}
\concept{expression generators}
