% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.garma_model}
\alias{predict.garma_model}
\title{Predict future values.}
\usage{
\method{predict}{garma_model}(object, n.ahead = 1, newdata = NULL, ...)
}
\arguments{
\item{object}{(garma_model) The garma_model from which to predict the values. This should have been generated by the [garma()]
function.}

\item{n.ahead}{(int) The number of time periods to predict ahead. Default: 1}

\item{newdata}{(real vector or matrix) If the original model was fitted with the 'xreg=' option then this will provide the xreg
  values for predictions. If this is a vector then its length should be 'n.ahead'; if it is a matrix then it should have
  'n.ahead' rows.

  It should have columns with the same names as the original xreg matrix.}

\item{...}{Other parameters. Ignored.}
}
\value{
A "ts" object containing the requested forecasts.
}
\description{
Predict ahead using algorithm of Godet (2009).
}
\examples{
data(AirPassengers)
ap <- as.numeric(diff(AirPassengers, 12))
mdl <- garma(ap, order = c(9, 1, 0), k = 0, method = "CSS", include.mean = FALSE)
predict(mdl, n.ahead = 12)
}
\references{
Godet, F. Linear prediction of long-range dependent time series, ESAIM: PS (2009) 13 115-134.
DOI: https://doi.org/10.1051/ps:2008015
}
