% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_bootstrap.R
\name{gas_bootstrap}
\alias{gas_bootstrap}
\title{Bootstrap GAS Model}
\usage{
gas_bootstrap(gas_object = NULL, method = "parametric", rep_boot = 1000L,
  quant = c(0.025, 0.975), y = NULL, x = NULL, distr = NULL,
  param = NULL, scaling = "unit", spec = "joint", p = 1L, q = 1L,
  par_static = NULL, par_link = NULL, par_init = NULL, lik_skip = 0L,
  coef_fix_value = NULL, coef_fix_other = NULL, coef_fix_special = NULL,
  coef_bound_lower = NULL, coef_bound_upper = NULL, coef_est = NULL,
  optim_function = wrapper_optim_nloptr, optim_arguments = list(opts =
  list(algorithm = "NLOPT_LN_NELDERMEAD", xtol_rel = 0, maxeval = 1e+06)))
}
\arguments{
\item{gas_object}{An optional GAS estimate, i.e. a list of S3 class \code{gas} returned by function \code{\link[gasmodel:gas]{gas()}}.}

\item{method}{A method used for bootstrapping. Currently, the only supported method is \code{"parametric"}.}

\item{rep_boot}{A number of bootstrapping repetitions.}

\item{quant}{A numeric vector of probabilities determining quantiles.}

\item{y}{A time series. For univariate time series, a numeric vector or a matrix with a single column. For multivariate times series, a numeric matrix with observations in rows.}

\item{x}{Optional exogenous variables. For a single variable common for all time-varying parameters, a numeric vector. For multiple variables common for all time-varying parameters, a numeric matrix with observations in rows. For individual variables for each time-varying parameter, a list of numeric vectors or matrices in the above form. The number of observation must be equal to the number of observations of \code{y}.}

\item{distr}{A conditional distribution. See \code{\link[gasmodel:distr]{distr()}} for available distributions.}

\item{param}{A parametrization of the conditional distribution. If \code{NULL}, default parametrization is used. See \code{\link[gasmodel:distr]{distr()}} for available parametrizations.}

\item{scaling}{A scaling function for the score. The supported scaling functions are the unit scaling (\code{scaling = "unit"}), the inverse of the Fisher information matrix scaling (\code{scaling = "fisher_inv"}), and the inverse square root of the Fisher information matrix scaling (\code{scaling = "fisher_inv_sqrt"}). The latter two scalings use the Fisher information for the time-varying parameters only. For the full Fisher information matrix for both time-varying and static parameters, there are the \code{"full_fisher_inv"} and \code{"full_fisher_inv_sqrt"} scalings. For the individual Fisher information for each parameter, there are the \code{"diag_fisher_inv"} and \code{"diag_fisher_inv_sqrt"} scalings. Note that when the parametrization is orthogonal (see \code{\link[gasmodel:distr]{distr()}}), there are no differences between these scaling variants.}

\item{spec}{A specification of the dynamic equation with regard to exogeneous variables. The supported specifications are exogenous variables and dynamics within the same equation (\code{spec = "joint"}) and separate equations for exogenous variables and dynamics in the fashion of regression models with dynamic errors (\code{spec = "reg_err"}). In a stationary model without exogenous variables, the two specifications are equivalent, although with differently parametrized intercept.}

\item{p}{A score order. For order common for all parameters, a numeric vector of length 1. For individual order for each parameter, a numeric vector of length equal to the number of parameters. Defaults to \code{1L}.}

\item{q}{An autoregressive order. For order common for all parameters, a numeric vector of length 1. For individual order for each parameter, a numeric vector of length equal to the number of parameters. Defaults to \code{1L}.}

\item{par_static}{An optional logical vector indicating static parameters. Overrides \code{x}, \code{p}, and \code{q}.}

\item{par_link}{An optional logical vector indicating whether the logarithmic/logistic link should be applied to restricted parameters in order to obtain unrestricted values. Defaults to applying the logarithmic/logistic link for time-varying parameters and keeping the original link for constant parameters.}

\item{par_init}{An optional numeric vector of initial values of time-varying parameters. For \code{NA} values or when \code{NULL}, set initial values to unconditional values of time-varying parameters. For example, in the case of GAS(1,1) model with \code{spec = "joint"}, to \code{omega / (1 - phi1)}. Not to be confused with starting values for the optimization \code{coef_start}.}

\item{lik_skip}{A numeric value specifying the number of skipped observations at the beginning of the time series or after \code{NA} values in the likelihood computation. Defaults to \code{0L}, i.e. the full likelihood. If \code{NULL}, it is selected as \code{max(p,q)}, i.e. the conditional likelihood.}

\item{coef_fix_value}{An optional numeric vector of values to which coefficients are to be fixed. \code{NA} values represent oecfficients to be estimated.}

\item{coef_fix_other}{An optional square numeric matrix of multiples of the estimated coefficients, which are to be added to the fixed coefficients. This allows the fixed coefficients to be linear combinations of the estimated coefficients. A coefficient given by row is fixed on coefficient given by column. By this logic, all rows corresponding to the estimated coefficients should contain only \code{NA} values. Furthermore, all columns corresponding to the fixed coefficients should also contain only \code{NA} values.}

\item{coef_fix_special}{An optional character vector of predefined structures of \code{coef_fix_value} and \code{coef_fix_other}. Useful mainly for multidimensional models. Value \code{"panel_structure"} forces all regression, autoregression, and score coefficients to be the same for all time-varying parameters within their group. Value \code{"zero_sum_intercept"} forces all constant parameters to sum up to zero within their group. Value \code{"random_walk"} forces all autoregressive coefficients to be equal to one (should be used with caution due to nonstationarity; \code{par_init} must be specified). Multiple predefined structures can be used together. Also can be used in combination with custom \code{coef_fix_value} and \code{coef_fix_other}.}

\item{coef_bound_lower}{An optional numeric vector of lower bounds on coefficients.}

\item{coef_bound_upper}{An optional numeric vector of upper bounds on coefficients.}

\item{coef_est}{A numeric vector of estimated coefficients.}

\item{optim_function}{An optimization function. For suitable wrappers of common R optimization functions, see \code{\link[gasmodel:wrappers_optim]{wrappers_optim}}. Can be set to \code{NULL} if the optimal solution should not be computed, which can be useful if the goal is only to evaluate the fit for the coefficients specified in argument \code{coef_start}.}

\item{optim_arguments}{An optional list of arguments to be passed to the optimization function.}
}
\value{
A list with components:
\item{data$y}{The time series.}
\item{data$x}{The exogenous variables.}
\item{model$distr}{The conditional distribution.}
\item{model$param}{The parametrization of the conditional distribution.}
\item{model$scaling}{The scaling function.}
\item{model$spec}{The specification of the dynamic equation.}
\item{model$t}{The length of the time series.}
\item{model$n}{The dimension of the model.}
\item{model$m}{The number of exogenous variables.}
\item{model$p}{The score order.}
\item{model$q}{The autoregressive order.}
\item{model$par_static}{The static parameters.}
\item{model$par_link}{The parameters with the logarithmic/logistic links.}
\item{model$par_init}{The initial values of the time-varying parameters.}
\item{model$lik_skip}{The number of skipped observations at the beginning of the time series or after \code{NA} values in the likelihood computation.}
\item{model$coef_fix_value}{The values to which coefficients are fixed.}
\item{model$coef_fix_other}{The multiples of the estimated coefficients, which are added to the fixed coefficients.}
\item{model$coef_fix_special}{The predefined structures of \code{coef_fix_value} and \code{coef_fix_other}.}
\item{model$coef_bound_lower}{The lower bounds on coefficients.}
\item{model$coef_bound_upper}{The upper bounds on coefficients.}
\item{model$coef_est}{The estimated coefficients.}
\item{bootstrap$method}{The method used for bootstrapping.}
\item{bootstrap$coef_set}{The bootstrapped sets of coefficients.}
\item{bootstrap$coef_mean}{The mean of boostrapped coefficients.}
\item{bootstrap$coef_vcov}{The variance-covariance matrix of boostrapped coefficients.}
\item{bootstrap$coef_sd}{The standard deviation of boostrapped coefficients.}
\item{bootstrap$coef_quant}{The quantiles of boostrapped coefficients.}
}
\description{
A function for bootsrapping coefficients of generalized autoregressive score (GAS) models of Creal et al. (2013) and Harvey (2013).
Method \code{"parametric"} repeatedly simulates time series using the parametric model and re-estimates coefficients.
Instead of supplying arguments about the model, the function can be applied to the \code{gas} object obtained by the \code{\link[gasmodel:gas]{gas()}} function.
}
\examples{
# Load Level of Lake Huron dataset
data(LakeHuron)
y <- LakeHuron - 570
x <- 1:length(y)

# Estimate GAS model based on the normal distribution with dynamic mean
est_gas <- gas(y = y, x = x, distr = "norm", spec = "reg_err",
  par_static = c(FALSE, TRUE), coef_start = c(9.99, -0.02, 0.46, 0.67, 0.46))
est_gas

# Bootstrap the model (can be time-consuming for a larger number of samples)
\donttest{boot_gas <- gas_bootstrap(est_gas, rep_boot = 10)
boot_gas}

}
\references{
Creal, D., Koopman, S. J., and Lucas, A. (2013). Generalized Autoregressive Score Models with Applications. \emph{Journal of Applied Econometrics}, \strong{28}(5), 777–795. \doi{10.1002/jae.1279}.

Harvey, A. C. (2013). \emph{Dynamic Models for Volatility and Heavy Tails: With Applications to Financial and Economic Time Series}. Cambridge University Press. \doi{10.1017/cbo9781139540933}.
}
\seealso{
\code{\link[gasmodel:gas]{gas()}}
}
