% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_gaussian_fits.R
\name{compare_gaussian_fits}
\alias{compare_gaussian_fits}
\title{Compare fitted 2D Gaussians and determine the best-fitting model}
\usage{
compare_gaussian_fits(fit_objects_list, comparison_method = "rmse")
}
\arguments{
\item{fit_objects_list}{A list of outputs from \code{fit_gaussian_2D()}. See
Details for more}

\item{comparison_method}{One of "rmse", "rss", or "AIC"; what metric should
be used to determine the "best-fitting" Gaussian?}
}
\value{
A list with the components:
\itemize{
\item{"preferred_model"} {A character indicating the name of the preferred
model (or if a named list was not provided, a model number is given in
the order of the original supplied list). }
\item{"comparison_table"} {A data.frame detailing the rss, rmse, deviance,
and AIC of the fitted models. The data.frame is sorted by the
comparison_method that was selected.}
}
}
\description{
Compare fitted 2D Gaussians and determine the best-fitting model
}
\details{
For the argument \code{fit_objects_list}, a list of fitted model
objects (output from \code{fit_gaussian_2D()}) can simply be combined via
\code{list()}. Naming the list is optional; should you supply names, the
output of \code{compare_gaussian_fits()} will refer to specific models by
these names.
}
\examples{
if (interactive()) {
  library(gaussplotR)

  ## Load the sample data set
  data(gaussplot_sample_data)

  ## The raw data we'd like to use are in columns 1:3
  samp_dat <-
    gaussplot_sample_data[,1:3]

  ## Fit a variety of different models
  gauss_fit_ue <-
    fit_gaussian_2D(samp_dat)
  gauss_fit_uel <-
    fit_gaussian_2D(samp_dat, method = "elliptical_log")
  gauss_fit_cir <-
    fit_gaussian_2D(samp_dat, method = "circular")

  ## Combine the outputs into a list
  models_list <-
    list(
      unconstrained_elliptical = gauss_fit_ue,
      unconstrained_elliptical_log = gauss_fit_uel,
      circular = gauss_fit_cir
    )

  ## Compare via rmse
  models_compared <-
    compare_gaussian_fits(
      fit_objects_list = models_list,
      comparison_method = "rmse" ## the default
    )
}
}
\author{
Vikram B. Baliga
}
