% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_static_feeds.R
\name{get_system_regions}
\alias{get_system_regions}
\title{Grab the system_regions feed.}
\usage{
get_system_regions(city, directory = NULL, file = "system_regions.rds",
  output = "save")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed. See \code{get_gbfs_cities}
for a current list of available cities.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of the file to be saved. Must end in .rds.}

\item{output}{The type of output method. If `output = "save"`, the object will be saved as
an .rds object at the given path. If `output = "return"`, the output will be returned
as a dataframe object. Setting `output = "both"` will do both.}
}
\value{
Depends on argument to `output`: Either a saved .rds object generated from the 
current system_alerts feed, a dataframe object, or both.
}
\description{
\code{get_system_regions} grabs and tidies the system_regions feed for a given city. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for this dataset.
}
\examples{
\donttest{get_system_regions(city = 
"http://biketownpdx.socialbicycles.com/opendata/system_regions.json", directory = tempdir())}
\donttest{get_system_regions(city = "Boston", directory = tempdir())}
}
