% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.lmplots.R
\name{gbm.lmplots}
\alias{gbm.lmplots}
\title{Plot linear models for all expvar against the resvar}
\usage{
gbm.lmplots(
  samples = NULL,
  expvar = NULL,
  resvar = NULL,
  expvarnames = NULL,
  resvarname = NULL,
  savedir = NULL,
  plotname = NULL,
  pngtype = c("cairo-png", "quartz", "Xlib"),
  r2line = TRUE,
  pointtext = FALSE,
  pointlabs = resvar,
  pointcol = "black",
  ...
)
}
\arguments{
\item{samples}{Explanatory and response variables to predict from. Keep col
names short (~17 characters max), no odd characters, spaces, starting
numerals or terminal periods. Spaces may be converted to periods in directory
names, underscores won't. Can be a subset of a large dataset.}

\item{expvar}{Vector of names or column numbers of explanatory variables in
'samples': c(1,3,6) or c("Temp","Sal"). No default.}

\item{resvar}{Name or column number(s) of response variable in samples: 12,
c(1,4), "Rockfish". No default. Column name is ideally species name.}

\item{expvarnames}{Vector of names same length as expvar, if you want nicer names.}

\item{resvarname}{Single character object, if you want a nicer resvar name.}

\item{savedir}{Save location, end with "/".}

\item{plotname}{Character vector of plot names else expvarnames else expvar will be used.}

\item{pngtype}{Filetype for png files, alternatively try "quartz" on Mac.}

\item{r2line}{Plot rsquared trendline, default TRUE.}

\item{pointtext}{Label each point? Default FALSE.}

\item{pointlabs}{Point labels, defaults to resvar value.}

\item{pointcol}{Points colour, default "black".}

\item{...}{Allows controlling of text label params e.g. adj cex &.}
}
\value{
Invisibly saves png plots into savedir.
}
\description{
Loops the lmplot function, shows linear model plots for all expvar against the resvar. Good
practice to do this before running gbm.auto so you have a sense of the basic relationship of the
variables.
}
\details{
Errors and their origins:
}
\author{
Simon Dedman, \email{simondedman@gmail.com}
}
