% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalinfo.R
\name{gdalinfo}
\alias{gdalinfo}
\title{Interface to GDAL's gdalinfo utility}
\usage{
gdalinfo(
  datasetname,
  ...,
  json,
  mm,
  stats,
  approx_stats,
  hist,
  nogcp,
  nomd,
  norat,
  noct,
  nofl,
  checksum,
  proj4,
  listmdd,
  mdd,
  wkt_format,
  sd,
  oo,
  IF,
  dryrun = FALSE,
  config_options = character(0),
  quiet = FALSE
)
}
\arguments{
\item{datasetname}{Path to a GDAL-supported readable datasource.}

\item{...}{Here, a placeholder argument that forces users to
supply exact names of all subsequent formal arguments.}

\item{json, mm, stats, approx_stats, hist, nogcp, nomd, norat, noct}{See
the GDAL project's
\href{https://gdal.org/programs/gdalinfo.html}{gdalinfo
documentation} for details.}

\item{nofl, checksum, proj4, listmdd, mdd, wkt_format, sd, oo, IF}{See the GDAL project's
\href{https://gdal.org/programs/gdalinfo.html}{gdalinfo
documentation} for details.}

\item{dryrun}{Logical (default \code{FALSE}). If \code{TRUE},
instead of executing the requested call to GDAL, the function
will print the command-line call that would produce the
equivalent output.}

\item{config_options}{A named character vector with GDAL config
options, of the form \code{c(option1=value1, option2=value2)}. (See
\href{https://gdal.org/user/configoptions.html}{here} for a
complete list of supported config options.)}

\item{quiet}{Logical (default \code{FALSE}). If \code{TRUE},
suppress printing of output to the console.}
}
\value{
Silently returns a character vector containing the
    information returned by the gdalinfo utility.
}
\description{
This function provides an interface mirroring that of the GDAL
command-line app \code{gdalinfo}. For a description of the
utility and the arguments that it takes, see the documentation at
\url{https://gdal.org/programs/gdalinfo.html}.
}
\examples{
ff <- system.file("extdata/maunga.tif", package = "gdalUtilities")
gdalinfo(ff)
}
\author{
Joshua O'Brien
}
