% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalmanage.R
\name{gdalmanage}
\alias{gdalmanage}
\title{gdalmanage}
\usage{
gdalmanage(
  mode,
  datasetname,
  newdatasetname,
  r,
  u,
  f,
  ignore.full_scan = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{mode}{Character. Mode of operation. "identify" | "copy" | "rename" | "delete". See details.}

\item{datasetname}{Character. Raster file to operate on.}

\item{newdatasetname}{Character. For copy and rename modes, you provide a source filename and a target filename, just like copy and move commands in an operating system.}

\item{r}{Logical. Recursively scan files/folders for raster files.}

\item{u}{Logical. Report failures if file type is unidentified.}

\item{f}{Character. format. Specify format of raster file if unknown by the application. Uses short data format name (e.g. GTiff).}

\item{ignore.full_scan}{Logical. If FALSE, perform a brute-force scan if other installs are not found.  Default is TRUE.}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}
}
\value{
Character.
}
\description{
R wrapper for gdalmanage: Identify, delete, rename and copy raster data files
}
\details{
This is an R wrapper for the 'gdalmanage' function that is part of the 
Geospatial Data Abstraction Library (GDAL).  It follows the parameter naming
conventions of the original function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single character string following,
precisely, the gdalinfo format (\url{http://gdal.org/gdalmanage.html}), or,
in some cases, can use R vectors to achieve the same end.  

Mode of operation
\itemize{
\item{mode="identify",datasetname: List data format of file.}
\item{mode="copy",datasetname,newdatasetname: Create a copy of the raster file with a new name.}
\item{mode="rename",datasetname,newdatasetname: Change the name of the raster file.}
\item{mode="delete",datasetname: Delete raster file.}
}
This function assumes the user has a working GDAL on their system.  If the 
"gdalUtils_gdalPath" option has been set (usually by gdal_setInstallation),
the GDAL found in that path will be used.  If nothing is found, gdal_setInstallation
will be executed to attempt to find a working GDAL.
}
\examples{
gdal_setInstallation()
valid_install <- !is.null(getOption("gdalUtils_gdalPath"))
if(valid_install)
{
	# Using identify mode
	# Report the data format of the raster file by using the identify mode 
 # and specifying a data file name:
	src_dataset <- system.file("external/tahoe_highrez.tif", package="gdalUtils")
	gdalmanage(mode="identify",datasetname=src_dataset)
	
	# Recursive mode will scan subfolders and report the data format:	
	src_dir <- system.file("external/", package="gdalUtils")
	gdalmanage(mode="identify",datasetname=src_dir,r=TRUE)
	
\dontrun{
		# Using copy mode	
		# Copy the raster data:
		file_copy <- tempfile(fileext=".tif")
		gdalmanage(mode="copy",src_dataset,file_copy)	
		file.exists(file_copy)
		
		# Using rename mode
		# Rename the raster data:
		new_name <- tempfile(fileext=".tif")
		gdalmanage(mode="rename",file_copy,new_name)	
		file.exists(new_name)
		
		# Using delete mode
		# Delete the raster data:
		gdalmanage(mode="delete",new_name)	
		file.exists(new_name)		
}
}
}
\references{
\url{http://www.gdal.org/gdalmanage.html}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) (wrapper) and Frank Warmerdam (GDAL lead developer).
}
