% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_unlink}
\alias{vsi_unlink}
\title{Delete a file}
\usage{
vsi_unlink(filename)
}
\arguments{
\item{filename}{Character string. The path of the file to be deleted.}
}
\value{
\code{0} on success or \code{-1} on an error.
}
\description{
\code{vsi_unlink()} deletes a file object from the file system.
This function goes through the GDAL \code{VSIFileHandler} virtualization and may
work on unusual filesystems such as in memory.
It is a wrapper for \code{VSIUnlink()} in the GDAL Common Portability Library.
Analog of the POSIX \code{unlink()} function.
}
\examples{
# regular file system for illustration
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
tmp_file <- paste0(tempdir(), "/", "tmp.tif")
file.copy(elev_file,  tmp_file)
vsi_stat(tmp_file)
vsi_unlink(tmp_file)
vsi_stat(tmp_file)
}
\seealso{
\code{\link[=deleteDataset]{deleteDataset()}}, \code{\link[=vsi_rmdir]{vsi_rmdir()}}, \code{\link[=vsi_unlink_batch]{vsi_unlink_batch()}}
}
