\name{simulglyph.vmf}
\alias{simulglyph.vmf}
\concept{Simulation}
\concept{ODF visualization}
\concept{Glyph mapping}
\title{Voxel Diffusion Profile Simulation and von Mises-Fisher Fibre Mapping}
\description{
The synthesized diffusion voxel profiles generated by \code{synthfiberss2z} are used to reconstruct ODF profiles using the GQI method for reconstruction.
ODF profiles and fibre directions are estimated by relying on von Mises-Fisher (vMF) distributions for directional mapping. 
}

\usage{
simulglyph.vmf(s2grid=NULL, angles=c(20,100), depth=3, b=3000,
 mddratio=1.24, sigma=NULL, threshold=0.4, snapshot=FALSE,
 savedir=tempdir(), pngfig="glyph1", showglyph=TRUE)
}

\arguments{
\item{s2grid}{ S2 shell grid, or other equivalent user specified grid. By default \code{s2grid=NULL} means that the grid is generated by \code{s2tessel.zorder}. }
\item{angles}{ angles in degrees of fibres to be used in simulation (default: two fibres with angles \code{c(20,100)}). }
\item{depth}{ sampling densities on the hemisphere used in simulation (default N=321; depth=3). }
\item{b}{ strength of the magnetic diffusion gradient (default b-value=3000). }
\item{mddratio}{ GQI parameter (default: 1.24). }
\item{sigma}{ Rician noise level used in simulation; (default \code{NULL}). }
\item{threshold}{ thresholding generalized fractional anisotropy (GFA) value at each voxel (default: 0.4). }
\item{snapshot}{ logical variable controlling line-map snapshots (default: \code{FALSE}). }
\item{savedir}{ directory for saving/loading processed results (default: \code{tempdir()}). }
\item{pngfig}{ base-name of the PNG files when \code{snapshot} is \code{TRUE} (default \code{"glyph1"}). }
\item{showglyph}{ logical variable controlling visualization of voxel glyphs (default: \code{TRUE}). }
}

\value{
\code{simulglyph.vmf} plots the reconstructed ODF profile together with the vMF-estimated fiber directions.
}

\details{
The number of fibres is automatically estimated from the diffusion profile.
To decide on the number of components to select the Bayesian information criterion (BIC) is applied. 
}

\references{
Ferreira da Silva, A. R. Facing the Challenge of Estimating Human Brain White Matter Pathways. In \emph{Proc. of the 4th International Joint Conference on Computational Intelligence} (Oct. 2012), K. Madani, J. Kacprzyk, and J. Filipe, Eds., SciTePress, pp. 709-714.

Hornik, K., and Gruen, B. \pkg{movMF}: Mixtures of von Mises-Fisher Distributions, 2012. R package version 0.0-2.

Adler, D., and Murdoch, D. \pkg{rgl}: 3D visualization device system (OpenGL), 2012. R package version 0.92.880.

Barber, C. B., Habel, K., Grasman, R., Gramacy, R. B., Stahel, A., and Sterratt, D. C. \pkg{geometry}: Mesh generation and surface tessellation, 2012. R package version 0.3-2.
} 

\author{ Adelino Ferreira da Silva, Universidade Nova de Lisboa,
  Faculdade de Ciencias e Tecnologia, Portugal, \email{afs at fct.unl.pt}
}

\seealso{
  \code{\link{synthfiberss2z}},
  \code{\link{plotglyph}},
  \code{\link{gqi.odfvmflines}},
  \code{\link{rgbvolmap}},
  \code{\link{gqi.odfpeaks}},
  \code{\link{gqi.odfpeaklines}},
  \code{\link{gqi.odfvxgrid}},
  \code{\link{simul.fandtasia}},
  \code{\link{simul.simplefield}}
}

\examples{
\dontrun{
    ## Examples of synthetized voxel diffusion glyphs, ODF glyphs,
    ## and vMF fiber orientation mapping 
    ##
    ## noise-free simulations and vMF estimation (2 directions)
    angles <- c(20,110); b <- 1500
    simulglyph.vmf(angles=angles,b=b)
    ## 2 direction, lower crossing-angles, higher b
    angles <- c(20,80); b <- 3000
    simulglyph.vmf(angles=angles,b=b)
    ## 2 direction, low croosing angle
    angles <- c(20,65); b <- 3000
    simulglyph.vmf(angles=angles,b=b)
    ## 3 directions
    angles <- c(20,80,140); b <- 3000
    simulglyph.vmf(angles=angles,b=b)
    # 3 directions
    angles <- c(0,60,120); b <- 3000
    simulglyph.vmf(angles=angles,b=b)
    ##------------------
    ## noisy simulations and vMF estimation
    angles <- c(20,110); b <- 1500; sigma <- 0.033
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
    # 2 direction, lower crossing-angles, higher b
    angles <- c(20,80); b <- 3000; sigma <- 0.033
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
    ## 2 direction, low croosing angle
    angles <- c(20,65); b <- 3000; sigma <- 0.033
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
    # 3 directions
    angles <- c(20,80,140); b <- 3000; sigma <- 0.033
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
    # 3 directions
    angles <- c(0,60,120); b <- 3000; sigma <- 0.033
    simulglyph.vmf(angles=angles,b=b, sigma=sigma)
}
}

\keyword{ utilities }

