% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_funcs.R
\name{gdl_indicators}
\alias{gdl_indicators}
\title{Get indicator list}
\usage{
gdl_indicators(session)
}
\arguments{
\item{session}{A valid GDL session object to interface with.}
}
\value{
A data frame containing a list of indicators for the dataset.
}
\description{
Returns the list of indicators available in the current dataset.
}
\examples{
\dontrun{
# Create a session using your API token (provided by environment here)
session <- gdl_session(Sys.getenv('GDL_API_TOKEN'))
# Request list of available indicators
indicators <- gdl_indicators(session)
head(indicators, n=10)
}
}
