% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psd_pseudop.R
\name{psmd_pseudop}
\alias{psmd_pseudop}
\title{power of spatial and multilevel discretization determinant(PSMD) and the corresponding pseudo-p value}
\usage{
psmd_pseudop(
  yobs,
  xobs,
  wt,
  discnum = 3:22,
  discmethod = "quantile",
  cores = 1,
  seed = 123456789,
  permutations = 0,
  ...
)
}
\arguments{
\item{yobs}{Variable Y}

\item{xobs}{The original undiscretized covariable X.}

\item{wt}{The spatial weight matrix.}

\item{discnum}{(optional) Number of multilevel discretization. Default will use \code{3:22}.}

\item{discmethod}{(optional) The discretization methods. Default will use \code{quantile}.
If \code{discmethod} is set to \code{robust}, the function \code{robust_disc()} will be used. Conversely,
if \code{discmethod} is set to \code{rpart}, the \code{rpart_disc()} function will be used. Others use
\code{st_unidisc()}. Currently, only one \code{discmethod} can be used at a time.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, use parallel computation.}

\item{seed}{(optional) Random seed number, default is \code{123456789}.}

\item{permutations}{(optional) The number of permutations for the PSD computation. Default is \code{0},
which means no pseudo-p values are calculated.}

\item{...}{(optional) Other arguments passed to \code{st_unidisc()},\code{robust_disc()} or \code{rpart_disc()}.}
}
\value{
A tibble of power of spatial and multilevel discretization determinant and the corresponding pseudo-p value.
}
\description{
Function for calculate power of spatial and multilevel discretization determinant and the corresponding pseudo-p value.
}
\details{
The power of spatial and multilevel discretization determinant formula is
\eqn{PSMDQ_s = MEAN(Q_s)}
}
\examples{
data('sim')
wt = inverse_distance_weight(sim$lo,sim$la)
psmd_pseudop(sim$y,sim$xa,wt)

}
\references{
Xuezhi Cang & Wei Luo (2018) Spatial association detector (SPADE),International
Journal of Geographical Information Science, 32:10, 2055-2075, DOI:  10.1080/13658816.2018.1476693
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
