% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vgram.R
\name{vgram}
\alias{vgram}
\title{Sample semivariogram}
\usage{
vgram(
  formula,
  data,
  coords = NULL,
  nbins = 10,
  maxd = NULL,
  angle = 0,
  ndir = 1,
  type = "standard",
  npmin = 2,
  longlat = FALSE
)
}
\arguments{
\item{formula}{A formula describing the relationship between the response and any covariates of interest, e.g., response ~ 1.  The variogram is computed for the residuals of the linear model \code{lm(formula, data)}.}

\item{data}{A data.frame, SpatialPointsDataFrame, SpatialPixelsDataFrame, or SpatialGridDataFrame object.}

\item{coords}{A formula specifiying (on the righthand side of ~) the coordinates in \code{data}.  Default is NULL, but this must be specified if \code{data} is of class \code{data.frame}.  This will probably look something like "~ x + y".}

\item{nbins}{The number of bins (tolerance regions) to use when estimating the sample semivariogram.}

\item{maxd}{The maximum distance used when calculating the semivariogram.  Default is NULL, in which case half the maximum distance between coordinates is used.}

\item{angle}{A single value (in degrees) indicating the starting direction for a directional variogram.  The default is 0.}

\item{ndir}{The number of directions for which to calculate a sample semivariogram.  The default is 1, meaning calculate an omnidirection semivariogram.}

\item{type}{The name of the estimator to use in the estimation process.  The default is "standard", the typical method-of-moments estimator.  Other options include "cressie" for the robust Cressie-Hawkins estimator, and "cloud" for a semivariogram cloud based on the standard estimator.  If "cloud" is specified, the \code{nbins} argument is ignored.}

\item{npmin}{The minimum number of pairs of points to use in the semivariogram estimator.  For any bins with fewer points, the estimate for that bin is dropped.}

\item{longlat}{A logical indicating whether Euclidean (\code{FALSE}) or Great Circle distance (WGS84 ellipsoid) (\code{longlat = TRUE}) should be used.  Default is \code{FALSE}.}
}
\value{
Returns a vgram object with components:
}
\description{
\code{vgram} calculates the sample semivariogram.
}
\details{
Note that the directions may be different from other packages (e.g., \code{gstat} or \code{geoR} packages) because those packages calculate angles clockwise from the y-axis, which is a convention frequently seen in geostatistics (e.g., the GSLIB software library).

Additionally, note that calculating the sample semivariogram for the residuals of lm(response ~ 1) will produce identical results to simply computing the sample semivariogram from the original response.  However, if a trend is specified (the righthand side of ~ has non-trival covariates), then the sample semivariogram of the residuals will differ from that of the original response.  A trend should be specified when the mean is non-stationary over the spatial domain.
}
\examples{
data(co)
v = vgram(Al ~ 1, co, ~ easting + northing)
plot(v)
v2 = vgram(Al ~ 1, co, ~ easting + northing, angle = 22.5, ndir = 4)
plot(v2)
}
\author{
Joshua French
}
