% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_geelite.R
\name{compile_db}
\alias{compile_db}
\title{Collect and Process Grid Statistics}
\usage{
compile_db(task, grid, mode, verbose)
}
\arguments{
\item{task}{[mandatory] (list) Session task that specifies the parameters
for data collection.}

\item{grid}{[mandatory] (sf) Simple features object containing the
geometries of the regions of interest.}

\item{mode}{[optional] (character) Mode of data extraction. Currently
supports \code{"local"} or \code{"drive"} (for larger exports via Google
Drive). Defaults to \code{"local"}.}

\item{verbose}{[mandatory] (logical) Display messages and progress status.}
}
\description{
This function retrieves and processes grid statistics from Google Earth
Engine (GEE) based on the specified session task. The collected data is
stored in SQLite format (\code{data/geelite.db}), along with supplementary
files such as CLI files (\code{cli/...}), the state file
(\code{state/state.json}), and the log file (\code{log/log.txt}).
}
\keyword{internal}
