% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gems.r
\docType{class}
\name{ArtCohort}
\alias{ArtCohort}
\alias{ArtCohort-class}
\alias{[,ArtCohort,ANY,ANY,ANY-method}
\alias{[,ArtCohort-method}
\alias{[.ArtCohort}
\alias{head,ArtCohort-method}
\alias{head.ArtCohort}
\alias{summary,ArtCohort-method}
\alias{summary.ArtCohort}
\alias{tail,ArtCohort-method}
\alias{tail.ArtCohort}
\alias{update,ArtCohort-method}
\alias{update.ArtCohort}
\title{Class \code{"ArtCohort"}}
\usage{
\S4method{[}{ArtCohort,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{update}{ArtCohort}(object, newsize, addbaseline = matrix(NA, nrow =
  newsize - object@size), newInitialStates = rep(1, newsize - object@size))

\S4method{head}{ArtCohort}(x, ...)

\S4method{tail}{ArtCohort}(x, ...)

\S4method{summary}{ArtCohort}(object)
}
\arguments{
\item{x,object}{an ArtCohort}

\item{i,j,drop}{same as for \code{data.frame}}

\item{...}{passed on to \code{data.frame} method}

\item{newsize}{size of the updated cohort}

\item{addbaseline}{baseline for new part of cohort}

\item{newInitialStates}{initial states for new part of cohort}
}
\description{
Is a S4 class for the artificial cohort generated by \code{simulateCohort}.
}
\section{Slots}{

\describe{
\item{\code{states.number}}{Object of class \code{"numeric"}: number of states}

\item{\code{size}}{Object of class \code{"numeric"}: cohort size}

\item{\code{baseline}}{Object of class \code{"matrix"}: baseline matrix}

\item{\code{follow.up}}{Object of class \code{"numeric"}: maximum follow-up time}

\item{\code{parameters}}{Object of class \code{"transition.structure"}: input parameters}

\item{\code{parametersCovariances}}{Object of class \code{"transition.structure"}:
input covariance matrices}

\item{\code{timeToTransition}}{Object of class \code{"matrix"}:
input timeToTransition matrix. logical components}

\item{\code{transitionFunctions}}{Object of class \code{"transition.structure"}:
input hazard functions}

\item{\code{time.to.state}}{Object of class \code{"data.frame"}: entry times for each
patient into each of the states}
}}
\section{Objects from the Class}{
 Objects are created by calls to the
function \code{simulateCohort}.
}
\examples{
showClass("ArtCohort")
}
\author{
Luisa Salazar Vizcaya, Nello Blaser, Thomas Gsponer
}
\seealso{
\code{\link{simulateCohort}},
\code{\link{transition.structure}},
\code{\link{transitionProbabilities}}, \code{\link{cumulativeIncidence}}
}
\keyword{classes}

