/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.BasicMCMCBond;
import gov.lanl.yadas.Binomial;
import gov.lanl.yadas.Likelihood;
import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MixtureBond;
import gov.lanl.yadas.ProbConverterArgument;
import gov.lanl.yadas.ReliableSystem;
import gov.lanl.yadas.ShortConstantArgument;
import gov.lanl.yadas.ShortIdentityArgument;
import gov.lanl.yadas.SystemProbArgument;
import java.util.ArrayList;

public class SystemBinomialBonds {
    ReliableSystem system;
    MCMCParameter p;
    MCMCParameter pi;
    double[] x;
    double[] n;
    ArrayList bondlist = new ArrayList();
    MCMCParameter[] paramvec;

    public SystemBinomialBonds(ReliableSystem system, MCMCParameter[] params, double[] x, double[] n) {
        this.system = system;
        this.x = x;
        this.n = n;
        int veclen = 2;
        if (params.length > 2) {
            veclen = 3;
        }
        this.paramvec = new MCMCParameter[veclen];
        this.p = this.paramvec[0] = params[0];
        this.pi = this.paramvec[1] = params[1];
        if (veclen == 3) {
            this.paramvec[2] = params[2];
        }
        double[] piv = this.pi.getValue();
        for (int i = 0; i < system.getSize(); ++i) {
            if (!(n[i] > 0.0)) continue;
            if (piv[i] > 0.0 && piv[i] < 1.0 || !this.pi.areConstant(i)) {
                this.bondlist.add(new MixtureBond(new MCMCParameter[][]{this.paramvec, this.paramvec}, new ArgumentMaker[][]{{new ShortConstantArgument(x, i), new ShortConstantArgument(n, i), new ShortIdentityArgument(0, i)}, {new ShortConstantArgument(x, i), new ShortConstantArgument(n, i), new SystemProbArgument(system, i)}}, new Likelihood[]{new Binomial(), new Binomial()}, new ProbConverterArgument(1, i)));
            } else if (piv[i] == 1.0) {
                this.bondlist.add(new BasicMCMCBond(this.paramvec, new ArgumentMaker[]{new ShortConstantArgument(x, i), new ShortConstantArgument(n, i), new SystemProbArgument(system, i)}, new Binomial()));
            } else if (piv[i] == 0.0) {
                this.bondlist.add(new BasicMCMCBond(this.paramvec, new ArgumentMaker[]{new ShortConstantArgument(x, i), new ShortConstantArgument(n, i), new ShortIdentityArgument(0, i)}, new Binomial()));
            }
            ((MCMCBond)this.bondlist.get(this.bondlist.size() - 1)).setName("SystemBinomialBond." + i);
        }
    }

    public ArrayList getList() {
        return this.bondlist;
    }
}

