/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.Likelihood;
import gov.lanl.yadas.Tools;

public class TiltedHypergeometric
implements Likelihood {
    public double compute(double[][] args) {
        double[] y = args[0];
        double[] n = args[1];
        double[] N = args[2];
        double[] C = args[3];
        double[] theta = args[4];
        double ss = 0.0;
        for (int i = 0; i < y.length; ++i) {
            double r1 = this.logchoose(n[i], y[i], -1);
            double r2 = this.logchoose(N[i] - n[i], C[i] - y[i], -1);
            double temp = 0.0;
            int k = (int)Math.max(0.0, n[i] - N[i] + C[i]);
            while ((double)k <= Math.min(n[i], C[i])) {
                temp += Math.exp(this.logchoose(n[i], k, -1) - r1 + this.logchoose(N[i] - n[i], C[i] - (double)k, -1) - r2 + theta[i] * ((double)k - y[i]));
                ++k;
            }
            ss += 1.0 / temp;
        }
        return Math.log(ss);
    }

    public double logchoose(double n, double x, int direction) {
        if (x > n || x < 0.0 || n < 0.0) {
            if (direction < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0 || x == n) {
            return 0.0;
        }
        return Tools.loggamma(n + 1.0) - Tools.loggamma(x + 1.0) - Tools.loggamma(n - x + 1.0);
    }
}

