/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common;

import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImageLoader {
    private Map<String, ImageIcon> d_icons;
    private String d_imagePath;

    public ImageLoader(String imagePath) {
        this.d_imagePath = imagePath;
        this.d_icons = new HashMap<String, ImageIcon>();
    }

    public ImageIcon getIcon(String name) {
        if (this.d_icons.containsKey(name)) {
            return this.d_icons.get(name);
        }
        URL imgURL = ImageLoader.class.getResource(this.deriveGfxPath(name));
        if (imgURL == null) {
            System.err.println("Error loading image " + this.deriveGfxPath(name));
            return null;
        }
        ImageIcon icon = new ImageIcon(imgURL);
        this.d_icons.put(name, icon);
        return icon;
    }

    public Image getImage(String name) {
        return this.getIcon(name) == null ? null : this.getIcon(name).getImage();
    }

    private String deriveGfxPath(String name) {
        return String.valueOf(this.d_imagePath) + name;
    }
}

