/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.validation;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBooleanModel
extends AbstractValueModel {
    private static final long serialVersionUID = -9103843138797710602L;
    protected Boolean d_val = null;
    protected final List<ValueModel> d_models;
    private PropertyChangeListener d_listener;

    public AbstractBooleanModel(List<ValueModel> models) {
        this.d_models = new ArrayList<ValueModel>(models);
        this.d_listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractBooleanModel.this.update();
            }
        };
        for (ValueModel model : this.d_models) {
            model.addValueChangeListener(this.d_listener);
        }
        this.update();
    }

    private void update() {
        Boolean oldVal = this.d_val;
        this.d_val = this.calc();
        this.fireValueChange(oldVal, this.d_val);
    }

    public void add(ValueModel vm) {
        if (!this.d_models.contains(vm)) {
            this.d_models.add(vm);
            vm.addValueChangeListener(this.d_listener);
            this.update();
        }
    }

    public void remove(ValueModel vm) {
        boolean removed = this.d_models.remove(vm);
        if (removed) {
            vm.removeValueChangeListener(this.d_listener);
            this.update();
        }
    }

    @Override
    public Boolean getValue() {
        return this.d_val;
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    protected boolean isBoolean(ValueModel model) {
        return model.getValue() != null && model.getValue() instanceof Boolean;
    }

    protected abstract Boolean calc();
}

