/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.BasicMCMCBond;
import gov.lanl.yadas.Beta;
import gov.lanl.yadas.Binomial;
import gov.lanl.yadas.ConstantArgument;
import gov.lanl.yadas.DataFrame;
import gov.lanl.yadas.FiniteUpdate;
import gov.lanl.yadas.IdentityArgument;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import java.util.ArrayList;

public class BetaBinomialExample {
    public static void main(String[] args) {
        int i;
        MCMCParameter y;
        int B = 1000;
        String direc = "";
        String filename = "scalars.dat";
        try {
            if (args.length > 0) {
                B = Integer.parseInt(args[0]);
            }
            if (args.length > 1) {
                direc = args[1];
            }
            if (args.length > 2) {
                filename = args[2];
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Poor argument list!" + e);
        }
        DataFrame d = new DataFrame(direc + filename);
        MCMCParameter x = new MCMCParameter(d.r("x"), d.r(1.0), direc + "x");
        MCMCParameter[] paramarray = new MCMCParameter[]{x, y = new MCMCParameter(d.r("y"), d.r("ymss"), direc + "y")};
        ArrayList<BasicMCMCBond> bondlist = new ArrayList<BasicMCMCBond>();
        BasicMCMCBond betabond = new BasicMCMCBond(new MCMCParameter[]{y}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(d.r("alpha")), new ConstantArgument(d.r("beta"))}, new Beta());
        bondlist.add(betabond);
        BasicMCMCBond binomialbond = new BasicMCMCBond(new MCMCParameter[]{x, y}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(d.r("n")), new IdentityArgument(1)}, new Binomial());
        bondlist.add(binomialbond);
        MCMCUpdate[] updatearray = new MCMCUpdate[]{y, new FiniteUpdate(x, d.i("ni"))};
        for (int b = 0; b < B; ++b) {
            if ((double)b / 1000.0 - (double)(b / 1000) == 0.0) {
                System.out.println(b);
            }
            for (i = 0; i < updatearray.length; ++i) {
                updatearray[i].update();
            }
            for (i = 0; i < paramarray.length; ++i) {
                if ((double)b / 1.0 - (double)(b / 1) != 0.0) continue;
                paramarray[i].output();
            }
        }
        for (int iii = 0; iii < updatearray.length; ++iii) {
            String acc = updatearray[iii].accepted();
            System.out.println("Update " + iii + ": " + acc);
        }
        for (i = 0; i < paramarray.length; ++i) {
            paramarray[i].finish();
        }
    }
}

