/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.AreTheyEqualArgument;
import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.BasicMCMCBond;
import gov.lanl.yadas.Beta;
import gov.lanl.yadas.Binomial;
import gov.lanl.yadas.CommonLogitPerturber;
import gov.lanl.yadas.ConstantArgument;
import gov.lanl.yadas.DataFrame;
import gov.lanl.yadas.EqualizingPerturber;
import gov.lanl.yadas.GroupArgument;
import gov.lanl.yadas.IdentityArgument;
import gov.lanl.yadas.JumpPerturber;
import gov.lanl.yadas.Likelihood;
import gov.lanl.yadas.LogitPerturber;
import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.MixtureBond;
import gov.lanl.yadas.ReversibleJumpUpdate;
import gov.lanl.yadas.SplittingLogitPerturber;
import java.util.ArrayList;

public class BinomialHypothesisTest {
    public static void main(String[] args) {
        int i;
        MCMCParameter lambda;
        int B = 1000;
        String direc = "c:/Java/MCMC/results/BinomialTest/";
        String filename = "p.dat";
        String shortfilename = "scalars.dat";
        try {
            if (args.length > 0) {
                B = Integer.parseInt(args[0]);
            }
            if (args.length > 1) {
                direc = args[1];
            }
            if (args.length > 2) {
                filename = args[2];
            }
            if (args.length > 3) {
                shortfilename = args[3];
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Poor argument list!" + e);
        }
        DataFrame d = new DataFrame(direc + filename);
        DataFrame d0 = new DataFrame(direc + shortfilename);
        MCMCParameter p = new MCMCParameter(d.r("p"), d.r(1.0), direc + "p");
        MCMCParameter[] paramarray = new MCMCParameter[]{p, lambda = new MCMCParameter(d0.r("lambda"), d0.r("lambdamss"), direc + "lambda")};
        ArrayList<MCMCBond> bondlist = new ArrayList<MCMCBond>();
        BasicMCMCBond databond = new BasicMCMCBond(new MCMCParameter[]{p}, new ArgumentMaker[]{new ConstantArgument(d.r("x")), new ConstantArgument(d.r("n")), new IdentityArgument(0)}, new Binomial());
        bondlist.add(databond);
        MixtureBond mixtureprior = new MixtureBond(new MCMCParameter[][]{{p}, {p}}, new ArgumentMaker[][]{{new IdentityArgument(0), new ConstantArgument(d.r("ap")), new ConstantArgument(d.r("bp"))}, {new GroupArgument(0, new int[]{0}), new ConstantArgument(d0.r("ap")), new ConstantArgument(d0.r("bp"))}}, new Likelihood[]{new Beta(), new Beta()}, new AreTheyEqualArgument(0, d0.r("lambda")[0]));
        bondlist.add(mixtureprior);
        databond.setName("databond");
        mixtureprior.setName("mixtureprior");
        MCMCUpdate[] updatearray = new MCMCUpdate[]{new ReversibleJumpUpdate(new MCMCParameter[]{p}, 2, 0, new double[]{d0.r("a00")[0], d0.r("a01")[0], d0.r("a10")[0], d0.r("a11")[0]}, new JumpPerturber[]{new LogitPerturber(0, d.r("pmss")), new EqualizingPerturber(0, d.r("n")), new SplittingLogitPerturber(0, d.r("psplitmss")), new CommonLogitPerturber(0, d0.r("pmss")[0])}, direc)};
        for (int b = 0; b < B; ++b) {
            if ((double)b / 1000.0 - (double)(b / 1000) == 0.0) {
                System.out.println(b);
            }
            for (i = 0; i < updatearray.length; ++i) {
                updatearray[i].update();
            }
            for (i = 0; i < paramarray.length; ++i) {
                if ((double)b / 1.0 - (double)(b / 1) != 0.0) continue;
                paramarray[i].output();
            }
        }
        for (int iii = 0; iii < updatearray.length; ++iii) {
            String acc = updatearray[iii].accepted();
            System.out.println("Update " + iii + ": " + acc);
        }
        for (i = 0; i < paramarray.length; ++i) {
            paramarray[i].finish();
        }
    }
}

