/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.util;

import java.util.List;
import org.drugis.common.stat.EstimateWithPrecision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerSimonianLairdPooling {
    private double d_pe;
    private double d_se;
    private double d_q;
    private int d_n;

    public DerSimonianLairdPooling(List<EstimateWithPrecision> estimates) {
        this(DerSimonianLairdPooling.getPointEstimates(estimates), DerSimonianLairdPooling.getStandardErrors(estimates));
    }

    public DerSimonianLairdPooling(double[] pe, double[] se) {
        if (pe.length != se.length) {
            throw new IllegalArgumentException("Input arrays must have equal length");
        }
        if (pe.length == 0) {
            throw new IllegalArgumentException("Input may not be empty");
        }
        this.d_n = pe.length;
        double[] weights = DerSimonianLairdPooling.calculateWeights(se);
        this.d_q = DerSimonianLairdPooling.calculateQ(weights, pe);
        double[] adjWeights = DerSimonianLairdPooling.calculateAdjustedWeights(weights, se, this.d_q);
        this.d_pe = DerSimonianLairdPooling.weightedSum(adjWeights, pe);
        this.d_se = DerSimonianLairdPooling.calculateError(adjWeights);
    }

    public EstimateWithPrecision getPooled() {
        return new EstimateWithPrecision(this.d_pe, this.d_se);
    }

    public double getHeterogeneity() {
        return this.d_q;
    }

    public double getHeterogeneityTestStatistic() {
        return Math.max(0.0, (this.d_q - (double)(this.d_n - 1)) / this.d_q);
    }

    private static double[] calculateWeights(double[] se) {
        double[] weights = new double[se.length];
        for (int i = 0; i < se.length; ++i) {
            weights[i] = 1.0 / (se[i] * se[i]);
        }
        return weights;
    }

    private static double calculateQ(double[] weights, double[] pe) {
        double theta = DerSimonianLairdPooling.weightedSum(weights, pe);
        double sum = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            double dev = pe[i] - theta;
            sum += weights[i] * dev * dev;
        }
        return sum;
    }

    private static double weightedSum(double[] w, double[] x) {
        double sum = 0.0;
        for (int i = 0; i < w.length; ++i) {
            sum += w[i] * x[i];
        }
        return sum / DerSimonianLairdPooling.sum(w);
    }

    private static double sum(double[] l) {
        double sum = 0.0;
        for (double d : l) {
            sum += d;
        }
        return sum;
    }

    private static double sumOfSquares(double[] l) {
        double sum = 0.0;
        for (double d : l) {
            sum += d * d;
        }
        return sum;
    }

    private static double[] calculateAdjustedWeights(double[] weights, double[] se, double q) {
        if (weights.length < 2) {
            return weights;
        }
        double tauSquared = DerSimonianLairdPooling.getTauSquared(weights, q);
        double[] adjusted = new double[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            adjusted[i] = 1.0 / (se[i] * se[i] + tauSquared);
        }
        return adjusted;
    }

    private static double getTauSquared(double[] weights, double q) {
        double k = weights.length;
        double num = q - (k - 1.0);
        double den = DerSimonianLairdPooling.sum(weights) - DerSimonianLairdPooling.sumOfSquares(weights) / DerSimonianLairdPooling.sum(weights);
        return Math.max(num / den, 0.0);
    }

    private static double calculateError(double[] adjWeights) {
        return 1.0 / Math.sqrt(DerSimonianLairdPooling.sum(adjWeights));
    }

    private static double[] getPointEstimates(List<EstimateWithPrecision> estimates) {
        double[] pe = new double[estimates.size()];
        for (int i = 0; i < pe.length; ++i) {
            pe[i] = estimates.get(i).getPointEstimate();
        }
        return pe;
    }

    private static double[] getStandardErrors(List<EstimateWithPrecision> estimates) {
        double[] se = new double[estimates.size()];
        for (int i = 0; i < se.length; ++i) {
            se[i] = estimates.get(i).getStandardError();
        }
        return se;
    }
}

