/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.summary;

import java.util.List;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsEvent;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.Parameter;
import org.drugis.mtc.summary.Summary;
import org.drugis.mtc.summary.SummaryUtil;

public class NodeSplitPValueSummary
extends AbstractObservable
implements Summary {
    public static final String PROPERTY_PVALUE = "pValue";
    private MCMCResults d_results;
    private Parameter d_direct;
    private Parameter d_indirect;
    private boolean d_defined;
    private double d_pvalue;

    public NodeSplitPValueSummary(double pvalue) {
        this.d_pvalue = pvalue;
        this.d_defined = true;
    }

    public NodeSplitPValueSummary(MCMCResults r, Parameter dir, Parameter indir) {
        this.d_results = r;
        this.d_direct = dir;
        this.d_indirect = indir;
        this.d_defined = false;
        this.d_results.addResultsListener(new MCMCResultsListener(){

            public void resultsEvent(MCMCResultsEvent event) {
                NodeSplitPValueSummary.this.calc();
            }
        });
        if (this.d_results.getNumberOfSamples() > 0) {
            this.calc();
        }
    }

    private void calc() {
        this.calculatePValue();
        this.d_defined = true;
        this.firePropertyChange(PROPERTY_PVALUE, null, this.d_pvalue);
        this.firePropertyChange("defined", false, true);
    }

    private void calculatePValue() {
        int nDirLargerThanIndir = 0;
        List<Double> directSamples = SummaryUtil.getAllChainsLastHalfSamples(this.d_results, this.d_direct);
        List<Double> indirectSamples = SummaryUtil.getAllChainsLastHalfSamples(this.d_results, this.d_indirect);
        int i = 0;
        while (i < directSamples.size()) {
            if (directSamples.get(i) > indirectSamples.get(i)) {
                ++nDirLargerThanIndir;
            }
            ++i;
        }
        double prop = (double)nDirLargerThanIndir / (double)directSamples.size();
        this.d_pvalue = 2.0 * Math.min(prop, 1.0 - prop);
    }

    public boolean getDefined() {
        return this.d_defined;
    }

    public double getPvalue() {
        return this.d_pvalue;
    }
}

