% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_raster_single}
\alias{plot_raster_single}
\title{Plot a single set of values onto a given landscape}
\usage{
plot_raster_single(values, landscape, title, no_data = 0, col)
}
\arguments{
\item{values}{a named list of values, the names must correspond to cells in the landscape}

\item{landscape}{a landscape to plot the values onto}

\item{title}{a title string for resulting plot, the time information will be taken and appended from the landscape id}

\item{no_data}{what value should be used for missing values in values}

\item{col}{corresponds to the \link{raster} col plot parameter. This can be omitted and colors handled by raster::plot}
}
\description{
Plot a single set of values onto a given landscape
}
\examples{
# get path to output objects
datapath <- system.file(file.path("extdata", "WorldCenter"), package = "gen3sis")

# plot environmental variables at a given step
landscape_t_150 <- readRDS(
  file.path(datapath, "output", "config_worldcenter", "landscapes", "landscape_t_150.rds"))
oldpar <- par(no.readonly = TRUE)
par(mfrow=c(1,2))
plot_raster_single(landscape_t_150$environment[,"temp"], landscape_t_150, "Temperature", NA)
# use col to change the color
plot_raster_single(landscape_t_150$environment[,"prec"], landscape_t_150, "Aridity", NA, 
                   col=topo.colors(5))
par(oldpar)
# note that these values were scaled by the configuration object
}
