% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hap2vcf.R
\name{vcf2hap}
\alias{vcf2hap}
\title{Generat Haps from VCF}
\usage{
vcf2hap(
  vcf,
  hapPrefix = "H",
  filter_Chr = FALSE,
  filter_POS = FALSE,
  pad = 3,
  hetero_remove = TRUE,
  na_drop = TRUE,
  ...
)
}
\arguments{
\item{vcf}{vcfR object imported by \code{import_vcf()}}

\item{hapPrefix}{prefix of hap names, default as "H"}

\item{filter_Chr}{not used}

\item{filter_POS}{not used}

\item{pad}{The number length in haplotype names should be extend to.}

\item{hetero_remove}{whether remove accessions contains hybrid site or not.
Default as \code{TRUE}}

\item{na_drop}{whether remove accessions contains unknown allele site or not
Default as \code{TRUE}.}

\item{...}{Parameters not used}
}
\value{
object of hapResult class
}
\description{
Generate hapResult from vcfR object
A simple filter by position was provided in this function,
however it's prefer to filter VCF (vcfR object) through
\code{\link[geneHapR:filter_vcf]{filter_vcf()}}.
}
\examples{
data("geneHapR_test")
hapResult <- vcf2hap(vcf)
}
\seealso{
extract genotype from vcf:
\code{\link[vcfR:extract_gt_tidy]{vcfR::extract_gt_tidy()}},
import vcf files:
\code{\link[geneHapR:import_vcf]{import_vcf()}} (preferred) and
\code{\link[vcfR:read.vcfR]{vcfR::read.vcfR()}},
filter vcf according \strong{position} and \strong{annotations}:
\code{\link[geneHapR:filter_vcf]{filter_vcf()}}
}
\author{
Zhangrenl
}
