% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genInfo.R
\name{genInfo}
\alias{genInfo}
\title{Get gene related information}
\usage{
genInfo(id = NULL, org, unique = FALSE)
}
\arguments{
\item{id}{Gene id (symbol, ensembl or entrez id) or uniprot id. If this argument is NULL, return all gene info.}

\item{org}{Short latin name from `ensOrg_name_data`.}

\item{unique}{Logical to keep only one matched ID, default is FALSE.}
}
\value{
A `data.frame`.
}
\description{
Get gene related information
}
\examples{
\donttest{
# input id contains fake id and one-to-many match id
x <- genInfo(id = c(
  "MCM10", "CDC20", "S100A9", "MMP1", "BCC7",
  "FAKEID", "TP53", "HBD", "NUDT10"
), org = "hg", unique = TRUE)
head(x)

}
}
