% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPubmed.R
\name{getPubmed}
\alias{getPubmed}
\title{Get 'PubMed' paper records by searching abstract}
\usage{
getPubmed(term, add_term = NULL, num = 100)
}
\arguments{
\item{term}{query terms e.g. gene id, GO/KEGG pathway}

\item{add_term}{other searching terms Default is NULL}

\item{num}{limit the number of records . Default is 100.}
}
\value{
A list of `tibble` for pubmed records
}
\description{
PubMed<https://pubmed.ncbi.nlm.nih.gov/> is a free search engine accessing primarily the database of references
and abstracts on life ciences and biomedical topics.
}
\examples{
\donttest{
term <- c("Tp53", "Brca1", "Tet2")
add_term <- c("stem cell", "mouse")
l <- getPubmed(term, add_term, num = 30)
# very easy to output
expoSheet(l, data_name = term, filename = "test.xlsx", dir = tempfile())
}
}
