% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parcor_ridg.R
\name{parcor_ridg}
\alias{parcor_ridg}
\title{Compute generalized (ridge-adjusted) partial correlation coefficients from matrix R*.}
\usage{
parcor_ridg(gmc0, dig = 4, idep = 1, verbo = FALSE, incr = 3)
}
\arguments{
\item{gmc0}{has a p by p matrix R* of generalized corr coefficients.}

\item{dig}{has the number of digits for reporting (=4, default)}

\item{idep}{is the column number of the first variable (=1, default)}

\item{verbo}{Make this TRUE for detailed printing of computational steps}

\item{incr}{{incremental constant for iteratively adjusting ridgek
      where ridgek is the constant times the identity matrix used to
  make sure that the gmc0 matrix is positive definite and iteratively
increased till all partial correlations are within the [-1,1] interval.}}
}
\value{
A five column `out' matrix containing partials. The first column=
  has the name of i=idep variable. The
   second column has the name of the j variable, while the third column has  r*(i,j|k).
  The 4-th column has  r*(j,i|k) (denoted partji), 5-th column has rijMrji
  that is difference in absolute values (abs(partij) - abs(partji)).
}
\description{
This function uses a generalized correlation matrix R* as input to compute
generalized partial correlations between \eqn{X_i} and one of the remaining
variables after removing the effect of all other variables in the matrix.
}
\note{
The ridgek constant created by the function may not be large enough to make sure that
 that other pairs of r*(i,j|k) are within the [-1,1] interval. The user may have to choose
 a suitable input `incr' to get the partials in  the [-1,1] interval. This function
 needs cofactor, minor and other functions in the memory.
}
\examples{

\dontrun{
set.seed(34);x=matrix(sample(1:600)[1:99],ncol=3)
colnames(x)=c("V1", "v2", "V3")
gm1=gmcmtx0(x)
parcor_ridg(gm1, idep=1)
}

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
Vinod, H. D. "Generalized Correlations and Instantaneous
 Causality for Data Pairs Benchmark," (March 8, 2015)
 \url{http://ssrn.com/abstract=2574891}

Vinod, H. D. "Matrix Algebra Topics in Statistics and Economics
 Using R", Chapter 4 in Handbook of Statistics: Computational Statistics
 with R, Vol.32, co-editors: M. B. Rao and C.R. Rao. New York:
 North Holland, Elsevier Science Publishers, 2014, pp. 143-176.
}
\seealso{
See Also \code{\link{parcor_ijk}}.
}
\keyword{correlations}
\keyword{partial}

